package org.ferris.journal.ejb.account;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.hibernate.validator.NotNull;

@Entity
@Table(name = "account") 
public class Account 
{
	@Transient
	private AccountStrategies strategies = new AccountStrategies();
	
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	
	@Id 
	@GeneratedValue
	@Column(name = "id")
	private Long id;
	public Long getId() { return id; }
	public void setId(Long id) 
	{
		Long min = 0L;
		
		Constraint<Long> constraint
			= new org.ferris.constraint.NotNull<Long>(new GreaterThan<Long>(min)); 
		
		Check check
			= constraint.check(id);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00005);
				log.info(e.toString());
				throw e;
			}
			else 
			if (check.equals(Check.LessThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00006, id, min);
				log.info(e.toString());
				throw e;
			}			
			else 
			if (check.equals(Check.EqualToMin)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00006, id, min);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.id = id; 
	}
	
	
	@Column(name = "username")
	@NotNull
	private String username;
	public String getUsername() { return username; }
	public void setUsername(String email) 
	{		
		int max = 50;
		
		Constraint<String> constraint
			= new org.ferris.constraint.NotNull<String>(new StringLengthLessThanOrEqualTo(max));
		
		Check check 
			= constraint.check(email);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00003);
				log.info(e.toString());
				throw e;
			}
			else if (check.equals(Check.GreaterThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00004, max, email.length(), email);
				log.info(e.toString());
				throw e;
			}
		}
		this.username = email; 
	}
	
	
	@Column(name = "password")
	@NotNull
	private String password;
	public String getPassword() { return password; }
	public void setPassword(String password) 
	{ 
		int max = 50;
		
		Constraint<String> constraint
			= new org.ferris.constraint.NotNull<String>(new StringLengthLessThanOrEqualTo(max));
		
		Check check 
			= constraint.check(password);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00007);
				log.info(e.toString());
				throw e;
			}
			else if (check.equals(Check.GreaterThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00008, max, password.length(), password);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.password = password; 
	}
	
	@Override
	public boolean equals(Object possibleAccount) {
		if (possibleAccount == null) {
			log.info("Parameter possibleAccount is null");
			return false;
		}
		if (! Account.class.isAssignableFrom(possibleAccount.getClass())) {
			log.info("Class "+possibleAccount.getClass().getName()+" not assignable to Account");
			return false;
		}
		return strategies.equals(this, (Account)possibleAccount);
	}
	
	@Override
	public String toString() {
		return strategies.format(this);
	}
	
	@Override
	public int hashCode() {
		return strategies.format(this).hashCode();
	}
}
