package org.ferris.journal.ejb.account;

import javax.persistence.Transient;

import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.ferris.journal.ejb.i18n.i18n;

public class AccountStrategies 
{
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	public String format(Account account) {
		return i18n.getString(
			  "AccountToString"
			, account.getId()
			, account.getPassword()
			, account.getUsername()
		);
	}
	
	public boolean equals(Account thiz, Account that)
	{
		return 
			logb("id", ObjectUtils.equals(thiz.getId(), that.getId()))
			&&
			logb("password", ObjectUtils.equals(thiz.getPassword(), that.getPassword()))
			&&
			logb("username", ObjectUtils.equals(thiz.getUsername(), that.getUsername()))
		;
	}
	
	private boolean logb(String property, boolean bool) {
		if (log.isDebugEnabled()) {
			log.debug("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		else
		if (!bool) {
			log.info("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		return bool;
	}
}
