package org.ferris.journal.ejb.journal;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.log4j.Logger;
import org.hibernate.validator.NotNull;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Entity
@Table(name = "journal") 
public class Journal 
{
	@Transient
	private JournalStrategies strategies = new JournalStrategies();
	
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	
	@ManyToOne()
    @JoinColumn(name="account_id")
    @NotNull
    private Account account;
    public Account getAccount() { return account; }
    public void setAccount(Account a) 
    { 
    	Constraint<Account> constraint
			= new org.ferris.constraint.NotNull<Account>(); 
		
		Check check
			= constraint.check(a);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00009);
				log.info(e.toString());
				throw e;
			}
		}
		
    	this.account = a; 
    }
	
	@Id 
	@GeneratedValue
	@Column(name = "id")
	private Long id;
	public Long getId() { return id; }
	public void setId(Long id) 
	{ 
		Long min = 0L;
		
		Constraint<Long> constraint
			= new org.ferris.constraint.NotNull<Long>(new GreaterThan<Long>(min)); 
		
		Check check
			= constraint.check(id);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {			
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00010);
				log.info(e.toString());
				throw e;
			}
			else 
			if (check.equals(Check.LessThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00011, id, min);
				log.info(e.toString());
				throw e;
			}			
			else 
			if (check.equals(Check.EqualToMin)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00011, id, min);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.id = id;
	}
	
	
	@Column(name = "created_on")
	@NotNull
	private Date createdOn;
	public Date getCreatedOn() { return createdOn; }
	public void setCreatedOn(Date d) 
	{ 
		Constraint<Date> constraint
			= new org.ferris.constraint.NotNull<Date>(); 
		
		Check check
			= constraint.check(d);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00012);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.createdOn = d; 
	}
	
	
	@Column(name = "name")
	@NotNull
	private String name;
	public String getName() { return name; }
	public void setName(String s) 
	{ 
		int max = 50;
		
		Constraint<String> constraint
			= new org.ferris.constraint.NotNull<String>(new StringLengthLessThanOrEqualTo(max));
		
		Check check 
			= constraint.check(s);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00013);
				log.info(e.toString());
				throw e;
			}
			else if (check.equals(Check.GreaterThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00014, max, s.length(), s);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.name = s;
	}
	
	
	@Column(name = "is_active")
	@NotNull
	private Boolean isActive;
	public Boolean getIsActive() { return isActive; }
	public void setIsActive(Boolean b) 
	{ 
		Constraint<Boolean> constraint
			= new org.ferris.constraint.NotNull<Boolean>(); 
		
		Check check
			= constraint.check(b);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00015);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.isActive = b;
	}
	
	
	@Override
	public boolean equals(Object possibleJournal) {
		if (possibleJournal == null) {
			log.info("Parameter possibleJournal is null");
			return false;
		}
		//if (! Journal.class.isAssignableFrom(possibleJournal.getClass())) {
		if (! (possibleJournal instanceof Journal)) {
			log.info("Class "+possibleJournal.getClass().getName()+" is not assignable to Journal");
			return false;
		}
		return strategies.equals(this, (Journal)possibleJournal);
	}
	
	@Override
	public String toString() {
		return strategies.format(this);
	}
	
	@Override
	public int hashCode() {
		return strategies.format(this).hashCode();
	}
}
