package org.ferris.journal.ejb.journal;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.log4j.Logger;
import org.hibernate.validator.NotNull;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Entity
@Table(name = "journal_entry") 
public class JournalEntry 
{
	@Transient
	private JournalEntryStrategies strategies = new JournalEntryStrategies();
	
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	
	@ManyToOne()
    @JoinColumn(name="account_id")
    @NotNull
    private Account account;
    public Account getAccount() { return account; }
    public void setAccount(Account a) 
    { 
    	Constraint<Account> constraint
			= new org.ferris.constraint.NotNull<Account>(); 
		
		Check check
			= constraint.check(a);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00025);
				log.info(e.toString());
				throw e;
			}
		}
		
    	this.account = a; 
    }
    
    
    @ManyToOne()
    @JoinColumn(name="journal_id")
    @NotNull
    private Journal journal;
    public Journal getJournal() { return journal; }
    public void setJournal(Journal j) 
    { 
    	Constraint<Journal> constraint
			= new org.ferris.constraint.NotNull<Journal>(); 
		
		Check check
			= constraint.check(j);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00026);
				log.info(e.toString());
				throw e;
			}
		}
		
    	this.journal = j; 
    }
    
	
	@Id 
	@GeneratedValue
	@Column(name = "id")
	private Long id;
	public Long getId() { return id; }
	public void setId(Long id) 
	{ 
		Long min = 0L;
		
		Constraint<Long> constraint
			= new org.ferris.constraint.NotNull<Long>(new GreaterThan<Long>(min)); 
		
		Check check
			= constraint.check(id);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {			
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00027);
				log.info(e.toString());
				throw e;
			}
			else 
			if (check.equals(Check.LessThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00028, id, min);
				log.info(e.toString());
				throw e;
			}			
			else 
			if (check.equals(Check.EqualToMin)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00029, id, min);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.id = id;
	}
	
	
	@Column(name = "created_on")
	@NotNull
	private Date createdOn;
	public Date getCreatedOn() { return createdOn; }
	public void setCreatedOn(Date d) 
	{ 
		Constraint<Date> constraint
			= new org.ferris.constraint.NotNull<Date>(); 
		
		Check check
			= constraint.check(d);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00030);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.createdOn = d; 
	}
	
	
	@Column(name = "subject")
	@NotNull
	private String subject;
	public String getSubject() { return subject; }
	public void setSubject(String s) 
	{ 
		int max = 100;
		
		Constraint<String> constraint
			= new org.ferris.constraint.NotNull<String>(new StringLengthLessThanOrEqualTo(max));
		
		Check check 
			= constraint.check(s);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00031);
				log.info(e.toString());
				throw e;
			}
			else if (check.equals(Check.GreaterThan)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00032, max, s.length(), s);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.subject = s;
	}
	
	
	@Column(name = "entry")
	@NotNull
	private String entry;
	public String getEntry() { return entry; }
	public void setEntry(String s) 
	{ 
		Constraint<String> constraint
			= new org.ferris.constraint.NotNull<String>();
		
		Check check 
			= constraint.check(s);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00033);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.entry = s;
	}
	
	
	@Column(name = "day")
	@NotNull
	private Date day;
	public Date getDay() { return day; }
	public void setDay(Date day) 
	{ 
		Constraint<Date> constraint
			= new org.ferris.constraint.NotNull<Date>();
		
		Check check 
			= constraint.check(day);
		
		if (check != null) {
			if (check.equals(Check.IsNull)) {
				DomainException e = new DomainException(DomainExceptionCode.DOMAIN00034);
				log.info(e.toString());
				throw e;
			}
		}
		
		this.day = day;
	}
	
	
	
	
	@Override
	public boolean equals(Object possibleJournalEntry) {
		if (possibleJournalEntry == null) {
			log.info("Parameter possibleJournalEntry is null");
			return false;
		}
		//if (! Journal.class.isAssignableFrom(possibleJournal.getClass())) {
		if (! (possibleJournalEntry instanceof JournalEntry)) {
			log.info("Class "+possibleJournalEntry.getClass().getName()+" is not assignable to JournalEntry");
			return false;
		}
		return strategies.equals(this, (JournalEntry)possibleJournalEntry);
	}
	
	@Override
	public String toString() {
		return strategies.format(this);
	}
	
	@Override
	public int hashCode() {
		return strategies.format(this).hashCode();
	}
}
