package org.ferris.journal.ejb.journal;

import java.util.Date;
import java.util.List;

import javax.ejb.Local;

import org.ferris.journal.ejb.lang.DomainException;

@Local
public interface JournalEntryLocal 
{
	public JournalEntry insert(JournalEntry journal)
	throws DomainException;
	
	public JournalEntry update(JournalEntry journal)
	throws DomainException;
	
	public Boolean delete(long accountId, long journalEntryId)
	throws DomainException;	
	
	public JournalEntry findById(long accountId, long journalEntryId)
	throws DomainException;
		
	public List<JournalEntry> findByJournal(long accountId, long journalId)
	throws DomainException;
	
	public List<JournalEntry> search(long accountId, String keyword, List<Long> journalIds, Date minInclusive, Date maxInclusive)
	throws DomainException;
	
}
