package org.ferris.journal.ejb.journal;

import javax.persistence.Transient;

import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.ferris.journal.ejb.i18n.i18n;

public class JournalEntryStrategies 
{
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	public String format(JournalEntry journalEntry) {
		return i18n.getString(
			  "JournalEntryToString"
			, journalEntry.getAccount()
			, journalEntry.getJournal()
			, journalEntry.getId()
			, journalEntry.getCreatedOn()
			, journalEntry.getDay()
			, journalEntry.getSubject()
		);
	}
	
	                      
	public boolean equals(JournalEntry thiz, JournalEntry that)
	{
		return 
			logb("id", ObjectUtils.equals(thiz.getId(), that.getId()))
			&&
			logb("accountId", ObjectUtils.equals(thiz.getAccount(), that.getAccount()))
			&&
			logb("createdOn", ObjectUtils.equals(thiz.getCreatedOn(), that.getCreatedOn()))
			&&
			logb("journalId", ObjectUtils.equals(thiz.getJournal(), that.getJournal()))
			&&
			logb("day", ObjectUtils.equals(thiz.getDay(), that.getDay()))
			&&
			logb("subject", ObjectUtils.equals(thiz.getSubject(), that.getSubject()))
			&&
			logb("entry", ObjectUtils.equals(thiz.getEntry(), that.getEntry()))
		;
	}
	
	private boolean logb(String property, boolean bool) {
		if (log.isDebugEnabled()) {
			log.debug("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		else
		if (!bool) {
			log.info("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		return bool;
	}
}
