package org.ferris.journal.ejb.journal;

import java.util.List;

import javax.ejb.Local;

import org.ferris.journal.ejb.lang.DomainException;

@Local
public interface JournalLocal 
{
	public Journal insert(Journal journal)
	throws DomainException;
	
	public Journal update(Journal journal)
	throws DomainException;
	
	public List<Journal> findByAccount(long accountId, Boolean isActive)
	throws DomainException;	
	
	public Journal findById(long accountId, long journalId)
	throws DomainException;
	
	public Boolean delete(long accountId, long journalId)
	throws DomainException;	
}
