package org.ferris.journal.ejb.journal;

import javax.persistence.Transient;

import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.ferris.journal.ejb.i18n.i18n;

public class JournalStrategies 
{
	@Transient
	private Logger log = Logger.getLogger(getClass());
	
	public String format(Journal journal) {
		return i18n.getString(
			  "JournalToString"
			, journal.getAccount()
			, journal.getId()
			, journal.getCreatedOn()
			, journal.getName()
			, journal.getIsActive()
		);
	}
	
	public boolean equals(Journal thiz, Journal that)
	{
		return 
		    logb("accountId", ObjectUtils.equals(thiz.getAccount(), that.getAccount()))
			&&
			logb("id", ObjectUtils.equals(thiz.getId(), that.getId()))
			&&
			logb("createdOn", ObjectUtils.equals(thiz.getCreatedOn(), that.getCreatedOn()))
			&&
			logb("name", ObjectUtils.equals(thiz.getName(), that.getName()))
			&&
			logb("isActive", ObjectUtils.equals(thiz.getIsActive(), that.getIsActive()))
		;
	}
	
	private boolean logb(String property, boolean bool) {
		if (log.isDebugEnabled()) {
			log.debug("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		else
		if (!bool) {
			log.info("Equals? " + property + ": " + String.valueOf(bool).toUpperCase()); 
		}
		return bool;
	}
}
