package org.ferris.journal.ejb.journal;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) 
	throws Exception
	{
		File data
			= new File("C:\\Documents and Settings\\mjremij\\Desktop\\dsrdiaryentry.dat");

		List<String[]> lines
			= new LinkedList<String[]>();
			
		InputStream is
			= new FileInputStream(data);
		
		InputStreamReader isr
			= new InputStreamReader(is);
		
		LineNumberReader reader
			= new LineNumberReader(isr);
		
		for (String line=reader.readLine(); line != null; line=reader.readLine())
		{
			String [] tokens
				= line.split("`");
			if (tokens.length != 9) {
				throw new RuntimeException("Line " + reader.getLineNumber() + " has "+tokens.length+" tokens ");
			}
			lines.add(tokens);
		}
		
		reader.close();
		
		for (Iterator<String[]> itr=lines.iterator(); itr.hasNext();) 
		{
			String [] strings = itr.next();
			if (!strings[4].equals("5")) {
				System.out.println("Remove: " + strings[4]);
				itr.remove();
			}
		}
		
		List<String[]> newLines = new ArrayList<String[]>(lines.size());
		
		int x = 0;
		for (Iterator<String[]> itr=lines.iterator(); itr.hasNext();) 
		{
			String [] oldStrings = itr.next();
			String [] newStrings = new String[7];
			
			newStrings[0] = "" + (++x);
 			newStrings[1] = "1";
			newStrings[2] = getJournalId(oldStrings[5]);
			newStrings[3] = oldStrings[2];
			newStrings[4] = oldStrings[6];
			newStrings[5] = oldStrings[7];
			newStrings[6] = oldStrings[8];
			
			newLines.add(newStrings);
		}
		
		File outFile = new File(data.getParentFile(), "NEW-" + data.getName());
		PrintWriter w = new PrintWriter(outFile);
		
		for (String[] strings : newLines) {
			for (int i=0; i<strings.length; i++) {
				if (i > 0) {
					w.print("\t");
				}
				w.print(strings[i]);
			}
			w.println();
		}
		w.flush();
		w.close();
		
		System.out.println("DONE");
	}
	
	public static String getJournalId(String id) 
	{
		if (id.equals("478hfhjdsg23459bnd")) {
			return "1";
		}
		else
		if (id.equals("caWzwrF9Qp58oIQSXGFF")) {
			return "2";
		}
		else
		if (id.equals("VeRdf4ZnvW5U3jCDNjYT")) {
			return "3";
		}
		else
		if (id.equals("255xmvqglMbFQXLWXHVB")) {
			return "4";
		}
		else
		if (id.equals("fqa36t6OYXpCGiStBAWN")) {
			return "5";
		}
		else
		if (id.equals("Anmlst3lHhHPSB60IVGT")) {
			return "6";
		}
		else	
		if (id.equals("kjLJLPEFwpqnbR93DYC2")) {
			return "7";
		}
		else {
			throw new RuntimeException("What is diary id " + id);
		}
				
		
		
		
		
		
		
	}

}
