package org.ferris.journal.ejb.lang;

/**
 * Most exceptions, runtime or checked, are fatal and the purpose
 * of this class is to wrap all checked exceptions and rethrow them
 * as a runtime exception.  The purpose of doing this is to prevent
 * littering the astronomy code with useless try/catch blocks.  
 * Chances are if an exception is raised the application will not
 * be able to recover. So instead of having astronomy code catch 
 * everything, the astronomy code will be developed strictly with
 * runtime exceptions and if an error occurs the top-most level of
 * the application will catch it, display an error message, and
 * exit the application.  Of course there will be exceptions to this
 * but those will be handled on a per case basis.
 * 
 * @author mjremij
 *
 */
public class DomainException extends RuntimeException 
{
	private static final long serialVersionUID = 79347697369894985L;

	private DomainExceptionCode code;
	
	public DomainException(DomainExceptionCode code, Object...messageParams)
	{
		super(code + ": " + code.getMessage(messageParams));
		this.code = code;
	}
	
	public DomainException(DomainExceptionCode code, Throwable throwable, Object...messageParams)
	{
		super(code.getMessage(messageParams), throwable);
		this.code = code;
	}
	
	public DomainExceptionCode getCode() {
		return code;
	}
}
