CREATE ROLE "JournalDS" LOGIN ENCRYPTED PASSWORD 'md52fd2684d0a514385490bcaeedd8e8dc7'
  NOINHERIT
   VALID UNTIL 'infinity';
   
ALTER Role "JournalDS" ENCRYPTED PASSWORD 'md507e6902c1773ceb4d8cc3747fb642f29';
   
CREATE SEQUENCE hibernate_sequence
  INCREMENT 1
  MINVALUE 1
  MAXVALUE 9223372036854775807
  START 1000
  CACHE 1;
ALTER TABLE hibernate_sequence OWNER TO postgres;
GRANT ALL ON TABLE hibernate_sequence TO postgres;
GRANT ALL ON TABLE hibernate_sequence TO "JournalDS";   


CREATE TABLE account
(
  id bigint NOT NULL,
  username character varying(50) NOT NULL,
  "password" character varying(50) NOT NULL,
  CONSTRAINT pk_id PRIMARY KEY (id),
  CONSTRAINT uniq_email UNIQUE (username)
) 
WITHOUT OIDS;
ALTER TABLE account OWNER TO postgres;
GRANT ALL ON TABLE account TO postgres;
GRANT ALL ON TABLE account TO "JournalDS";

/*
REVOKE ALL ON TABLE account FROM "JournalDS";
*/

CREATE TABLE journal
(
  id bigint NOT NULL,
  account_id bigint NOT NULL,
  created_on timestamp without time zone NOT NULL,
  name character varying(50) NOT NULL,
  is_active boolean NOT NULL DEFAULT true,
  CONSTRAINT journal_pk PRIMARY KEY (id),
  CONSTRAINT journal_account_fk FOREIGN KEY (account_id)
      REFERENCES account (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
) 
WITHOUT OIDS;
ALTER TABLE journal OWNER TO postgres;
GRANT ALL ON TABLE journal TO postgres;
GRANT ALL ON TABLE journal TO "JournalDS";


CREATE TABLE journal_entry
(
  id bigint NOT NULL,
  account_id bigint NOT NULL,
  journal_id bigint NOT NULL,
  created_on timestamp without time zone NOT NULL,
  day timestamp with time zone NOT NULL,
  subject character varying(100) NOT NULL,
  entry text NOT NULL,
  CONSTRAINT journal_entry_pk PRIMARY KEY (id),
  CONSTRAINT journal_entry_account_fk FOREIGN KEY (account_id)
      REFERENCES account (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
   CONSTRAINT journal_entry_journal_fk FOREIGN KEY (journal_id)
      REFERENCES journal (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
) 
WITHOUT OIDS;
ALTER TABLE journal_entry OWNER TO postgres;
GRANT ALL ON TABLE journal_entry TO postgres;
GRANT ALL ON TABLE journal_entry TO "JournalDS";

