package org.ferris.journal.ejb.account.junit.Account;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Id {

	@Test
	public void setId_PassValidValue() {
		Long id = 6L;
		Account a = new Account();
		a.setId(id);
		assertEquals(id, a.getId());
	}
	
	
	@Test
	public void setId_PassNull() {
		DomainException caught = null;
		try {
			new Account().setId(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00005, caught.getCode());
	}
	
	@Test
	public void setId_PassLessThanMin() {		
		DomainException caught = null;
		try {
			new Account().setId(-1L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00006, caught.getCode());
	}
	
	
	@Test
	public void setId_PassEqualToMin() {		
		DomainException caught = null;
		try {
			new Account().setId(0L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00006, caught.getCode());
	}
}
