package org.ferris.journal.ejb.account.junit.Account;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Password {

	@Test
	public void setter_PassValidValue() {
		String password = "KJFGK498769837";
		Account a = new Account();
		a.setPassword(password);
		assertEquals(password, a.getPassword());
	}
	
	
	@Test
	public void setter_PassNull() {
		DomainException caught = null;
		try {
			new Account().setPassword(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00007, caught.getCode());
	}
	
	@Test
	public void setter_PassGreaterThanMax() {
		StringBuilder sp = new StringBuilder();
		for (int i=0; i<=50; i++) {
			sp.append("a");
		}
		DomainException caught = null;
		try {
			new Account().setPassword(sp.toString());
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00008, caught.getCode());
	}
}
