package org.ferris.journal.ejb.account.junit.Account;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Username {

	@Test
	public void setUsername_PassValidValue() {
		String username = "user mike";
		Account a = new Account();
		a.setUsername(username);
		assertEquals(username, a.getUsername());
	}
	
	
	@Test
	public void setUsername_PassNull() {
		DomainException caught = null;
		try {
			new Account().setUsername(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00003, caught.getCode());
	}
	
	@Test
	public void setUsername_PassGreaterThanMax() {
		StringBuilder sp = new StringBuilder();
		for (int i=0; i<=50; i++) {
			sp.append("a");
		}
		DomainException caught = null;
		try {
			new Account().setUsername(sp.toString());
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown",caught);
		assertEquals(DomainExceptionCode.DOMAIN00004, caught.getCode());
	}
}
