package org.ferris.journal.ejb.account.junit.AccountEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class FindId extends AccountEjbTest
{
	private Account junitData;
	
	@Override
	public void before() {
		super.before();
		junitData = getAccountEjb().insert(AccountFactory.getAccount());
	}
	
	
	@Test
	public void findId() {
		Account a = getAccountEjb().findId(junitData.getId());
		assertTrue(junitData.equals(a));
	}
	
	
	@Test
	public void findIdThrowsExceptionWhenIdIsLessThanOne() {
		DomainException caught = null;
		try {
			getAccountEjb().findId(0L);
		} 
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainExceptionCode not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00001, caught.getCode());
	}
}
