package org.ferris.journal.ejb.account.junit.AccountEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class FindUsername extends AccountEjbTest
{
	private Account junitData;
	private String username;
	
	@Override
	public void before() {
		super.before();
		username = "FindUsername@JUnit.org";
		junitData = AccountFactory.getAccount(); {
			junitData.setUsername(username);
		}
		junitData = getAccountEjb().insert(junitData);
	}
	
	
	@Test
	public void findUsername() {
		Account a = getAccountEjb().findUsername(username);
		assertNotNull(a);
		assertTrue(junitData.equals(a));
	}
	
	
	@Test
	public void insertThrowsExceptionWhenUsernameIsNull() {
		DomainException caught = null;
		try {
			getAccountEjb().findUsername(null);
		} 
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00002, caught.getCode());
	}
	
}
