package org.ferris.journal.ejb.account.junit.AccountEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Insert extends AccountEjbTest
{
	
	
	@Test
	public void insert_passNull() {
		
		DomainException caught = null;
		try {
			getAccountEjb().insert(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00019, caught.getCode());
	}
	
	@Test
	public void insert() {
		Account a = AccountFactory.getAccount();
		Account b = getAccountEjb().insert(a);
		assertTrue(a.equals(b));
	}
}
