package org.ferris.journal.ejb.i18n.junit;

import static org.junit.Assert.assertEquals;

import java.text.ChoiceFormat;
import java.text.MessageFormat;

import org.ferris.journal.ejb.i18n.i18n;
import org.junit.Test;

public class i18nTest
{
	@Test
	public void choiceFormat()
	{
		 MessageFormat form = new MessageFormat("Please correct the following {0}.");
		 double[] filelimits = {1,2};
		 String[] filepart = {"error","{0,number} errors"};
		 ChoiceFormat fileform = new ChoiceFormat(filelimits, filepart);
		 form.setFormatByArgumentIndex(0, fileform);

		 assertEquals(
		    "Please correct the following {0,choice,1.0#error|2.0#{0,number} errors}."
		    ,form.toPattern()
		 );
	}
	
	@Test
	public void junit() {
		assertEquals("junit", i18n.getString("junit_string"));
	}
	
	@Test
	public void junitFormat() {
		assertEquals("junit_wow_1", i18n.getString("junit_format","wow", 1));
	}
}
