package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Account_ {

	@Test
	public void set_WithValue() {
		Journal j = JournalFactory.getJournal();
		Account a = AccountFactory.getAccount(12345L);
		j.setAccount(a);
		assertEquals(a, j.getAccount());
	}
	
	@Test
	public void set_PassNull() {
		DomainException caught = null;
		try {
			JournalFactory.getJournal().setAccount(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00009, caught.getCode());
	}
}
