package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Date;

import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class CreatedOn {

	@Test
	public void test_WithValue() {
		Journal a = JournalFactory.getJournal();
		Date d = new Date();		
		a.setCreatedOn(d);
		assertEquals(d, a.getCreatedOn());
	}
	
	@Test
	public void test_WithNull() {
		DomainException caught = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setCreatedOn(null);
		}
		catch (DomainException e) {
			caught = e;
		}		
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00012, caught.getCode());
	}
}
