package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.junit.Test;

public class Equals 
{	
	@Test
	public void testEqualsObject() 
	{
		Date d = new Date();
		
		String username = "kelly";
		String password = "it is encrypted";
		Long id = new Long(123);
		Account a = AccountFactory.getAccount(id); {
			Account x = a;
			x.setUsername(username);
			x.setPassword(password);
		}
		
		String journalName = "I'm a journal";
		Journal j = JournalFactory.getJournal(); {
			Journal x = j;
			x.setAccount(a);
			x.setCreatedOn(d);
			x.setId(id);
			x.setName(journalName);
			x.setIsActive(Boolean.TRUE);
		}
		
		
		Account aa = AccountFactory.getAccount(id); {
			Account x = aa;
			x.setUsername(username);
			x.setPassword(password);
		}
		Journal jj = JournalFactory.getJournal(); {
			Journal x = jj;
			x.setAccount(aa);
			x.setCreatedOn(d);
			x.setId(id);
			x.setName(journalName);
			x.setIsActive(Boolean.TRUE);
		}
		
		
		assertTrue(j.equals(jj));
				
		j.setCreatedOn(new Date());
		assertFalse(j.equals(jj));		
		j.setCreatedOn(d);
		assertTrue(j.equals(jj));
		
		j.setId(new Long(5));
		assertFalse(j.equals(jj));		
		j.setId(id);
		assertTrue(j.equals(jj));
		
		j.setName("clown");
		assertFalse(j.equals(jj));		
		j.setName(journalName);
		assertTrue(j.equals(jj));
		
		j.setIsActive(Boolean.FALSE);
		assertFalse(j.equals(jj));		
		j.setIsActive(Boolean.TRUE);
		assertTrue(j.equals(jj));
	}
}
