package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.junit.Test;

public class HashCode 
{	
	@Test
	public void testHashCode() 
	{
		Date d = new Date();
		
		String username = "kelly";
		String password = "it is encrypted";
		Long id = new Long(123);
		Account a = AccountFactory.getAccount(id); {
			Account x = a;
			x.setUsername(username);
			x.setPassword(password);
		}
		
		String journalName = "I'm a journal";
		Journal j = JournalFactory.getJournal(); {
			Journal x = j;
			x.setAccount(a);
			x.setCreatedOn(d);
			x.setId(id);
			x.setName(journalName);
			x.setIsActive(Boolean.TRUE);
		}
		
		
		Account aa = AccountFactory.getAccount(id); {
			Account x = aa;
			x.setUsername(username);
			x.setPassword(password);
		}
		Journal jj = JournalFactory.getJournal(); {
			Journal x = jj;
			x.setAccount(aa);
			x.setCreatedOn(d);
			x.setId(id);
			x.setName(journalName);
			x.setIsActive(Boolean.TRUE);
		}
		
		
		assertEquals(j.hashCode(), jj.hashCode());		
		j.setId(new Long(868686));
		assertFalse(j.hashCode() == jj.hashCode());
		j.setId(id);
		
		assertEquals(j.hashCode(), jj.hashCode());		
		j.setName("wow");
		assertFalse(j.hashCode() == jj.hashCode());
		j.setName(journalName);
		
		assertEquals(j.hashCode(), jj.hashCode());		
		j.setIsActive(Boolean.FALSE);
		assertFalse(j.hashCode() == jj.hashCode());
		j.setIsActive(Boolean.TRUE);
	}
	
}
