package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Id {

	@Test
	public void set_PassSomethingValid() {
		Long l = new Long(12345);
		Journal a = JournalFactory.getJournal();
		a.setId(l);
		assertEquals(l, a.getId());
	}
	
	@Test
	public void set_PassNull() {
		DomainException caught = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setId(null);
		}
		catch (DomainException e) {
			caught = e;
		}		
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00010, caught.getCode());
	}
	
	@Test
	public void set_PassLessThanMin() {
		DomainException caught = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setId(-1L);
		}
		catch (DomainException e) {
			caught = e;
		}		
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00011, caught.getCode());
	}
	
	@Test
	public void set_PassEqualToMin() {
		DomainException caught = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setId(0L);
		}
		catch (DomainException e) {
			caught = e;
		}		
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00011, caught.getCode());
	}
	
	
}
