package org.ferris.journal.ejb.journal.junit.Journal;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class Name {

	@Test
	public void test_WithValue() {
		Journal a = JournalFactory.getJournal();
		String s = "hello";
		a.setName(s);
		assertEquals(s, a.getName());
	}
	
	@Test
	public void set_PassNull() {
		DomainException caught  = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setName(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00013, caught.getCode());
			
	}
	
	
	@Test
	public void set_PassGreaterThanMax() {
		DomainException caught  = null;
		try {
			Journal a = JournalFactory.getJournal();
			a.setName("123456789_123456789_123456789_123456789_123456789_1");
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not caught", caught);
		assertEquals(DomainExceptionCode.DOMAIN00014, caught.getCode());
	}
	
	
	@Test
	public void set_PassEqualToMax() {
		Journal a = JournalFactory.getJournal();
		a.setName("123456789_123456789_123456789_123456789_123456789");
	}
	
	@Test
	public void test_WithLeftPadding() {
		Journal a = JournalFactory.getJournal();
		String s = "  hello";
		a.setName(s);
		assertEquals(s, a.getName());
	}
	
	
	@Test
	public void test_WithRightPadding() {
		Journal a = JournalFactory.getJournal();
		String s = "hello   ";
		a.setName(s);
		assertEquals(s, a.getName());
	}
	
	@Test
	public void test_WithBothPadding() {
		Journal a = JournalFactory.getJournal();
		String s = " hello   ";
		a.setName(s);
		assertEquals(s, a.getName());
	}
	
	@Test
	public void test_withAllPadding() {
		Journal a = JournalFactory.getJournal();
		String s = "    ";
		a.setName(s);
		assertEquals(s, a.getName());
	}
	
	@Test
	public void test_withEmptyString() {
		Journal a = JournalFactory.getJournal();
		String s = "";
		a.setName(s);
		assertEquals(s, a.getName());
	}
}
