package org.ferris.journal.ejb.journal.junit.JournalEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.junit.Journal.JournalFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class DeleteTest extends JournalEjbTest
{
	@Test
	public void _passAccountIdLessThanMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().delete(-1, 0);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00023, caught.getCode());
	}
	
	
	@Test
	public void _passAccountIdEqualToMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().delete(0, 0);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00023, caught.getCode());
	}
	
	
	@Test
	public void _passJournalIdLessThanMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().delete(1, -1);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00024, caught.getCode());
	}
	
	@Test
	public void _passJournalIdEqualMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().delete(1, 0);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00024, caught.getCode());
	}
	
	
	@Test
	public void _passIdsWhichDoNotExistInTheDatabase() {
		
			assertFalse(
				"The delete() method did not return false"
					,getJournalEjb().delete(11, 22)
				);
	}
	
	
	@Test
	public void _() {
		Account a = null;
		{
			a = AccountFactory.getAccount();
			a = getAccountEjb().insert(a);
		}
		
		Journal j = null;
		{
			j = JournalFactory.getJournal();
			j.setAccount(a);
			j.setCreatedOn(new Date());
			j.setIsActive(Boolean.TRUE);
			j.setName("mikey");
			j = getJournalEjb().insert(j);
		}
		
		assertTrue(
			"The delete() method did not return true"
				,getJournalEjb().delete(j.getAccount().getId(), j.getId())
			);
	}
}
