package org.ferris.journal.ejb.journal.junit.JournalEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Date;
import java.util.List;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.junit.Journal.JournalFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Before;
import org.junit.Test;

public class FindByAccountTest extends JournalEjbTest
{
	Account a1;
	Journal j1, j2;
	
	@Before
	public void before() 
	{
		super.before();
		
		Account 
			a = AccountFactory.getAccount();
			a1 = getAccountEjb().insert(a);
		
		Journal 
			// not active
			j = JournalFactory.getJournal();
			j.setAccount(a);
			j.setCreatedOn(new Date());
			j.setIsActive(Boolean.FALSE);
			j.setName("not active");
			j1 = getJournalEjb().insert(j);
			// active
			j = JournalFactory.getJournal();
			j.setAccount(a);
			j.setCreatedOn(new Date());
			j.setIsActive(Boolean.TRUE);
			j.setName("active");
			j2 = getJournalEjb().insert(j);
	}
	
	@Test
	public void find_accountId_passLessThanMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findByAccount(-1L, null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00017, caught.getCode());
	}
	
	
	@Test
	public void find_accountId_passEqualToMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findByAccount(0L, null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00017, caught.getCode());
	}
	
		
	@Test
	public void find_isActive_passNull() 
	{
		List<Journal>
			list = getJournalEjb().findByAccount(a1.getId(), null);
		
		assertEquals(2,  list.size());
		assertEquals(j1, list.get(0));
		assertEquals(j2, list.get(1));
	}
	
	
	@Test
	public void find_isActive_passTrue() 
	{
		List<Journal>
			list = getJournalEjb().findByAccount(a1.getId(), Boolean.TRUE);
		
		assertEquals(1,  list.size());
		assertEquals(j2, list.get(0));
	}
	
	@Test
	public void find_isActive_passFalse() 
	{
		List<Journal>
			list = getJournalEjb().findByAccount(a1.getId(), Boolean.FALSE);
		
		assertEquals(1,  list.size());
		assertEquals(j1, list.get(0));
	}
}
