package org.ferris.journal.ejb.journal.junit.JournalEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.junit.Journal.JournalFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class FindByIdTest extends JournalEjbTest
{
	@Test
	public void find_accountId_passLessThanMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findById(-1L, -1L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00022, caught.getCode());
	}
	
	
	@Test
	public void find_accountId_passEqualToMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findById(0L, -1L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00022, caught.getCode());
	}
	
	
	@Test
	public void find_id_passLessThanMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findById(10L, -1L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00016, caught.getCode());
	}
	
	
	@Test
	public void find_id_passEqualToMin() {
		
		DomainException caught = null;
		try {
			getJournalEjb().findById(10L, 0L);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00016, caught.getCode());
	}
	
	@Test
	public void find_shouldFindThisData() 
	{
		Account 
			a = AccountFactory.getAccount();
			a = getAccountEjb().insert(a);
		
		Journal 
			j = JournalFactory.getJournal();
			j.setAccount(a);
			j.setCreatedOn(new Date());
			j.setIsActive(Boolean.TRUE);
			j.setName("mikey");
			j = getJournalEjb().insert(j);
		

		Journal
			jj = getJournalEjb().findById(a.getId(), j.getId());
		
		assertEquals(jj, j);
	}
	
	@Test
	public void find_shouldNotFindThisData() 
	{
		Journal
			jj = getJournalEjb().findById(101010, 24242543);
		assertNull("I should not have found this data in the database.", jj);
	}
}
