package org.ferris.journal.ejb.journal.junit.JournalEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.junit.Journal.JournalFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class InsertTest extends JournalEjbTest
{
	@Test
	public void insert_passNull() {
		
		DomainException caught = null;
		try {
			getJournalEjb().insert(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00018, caught.getCode());
	}
	
	@Test
	public void insert() {
		Account a = AccountFactory.getAccount();
		a = getAccountEjb().insert(a);
		
		Journal j = JournalFactory.getJournal();
		j.setAccount(a);
		j.setCreatedOn(new Date());
		j.setIsActive(Boolean.TRUE);
		j.setName("mikey");
		
		Journal jj = getJournalEjb().insert(j);
		assertTrue("Journals not equal", j.equals(jj));
	}
}
