package org.ferris.journal.ejb.journal.junit.JournalEjb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Date;

import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.junit.Account.AccountFactory;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.junit.Journal.JournalFactory;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.junit.Test;

public class UpdateTest extends JournalEjbTest
{
	@Test
	public void _passNull() {
		
		DomainException caught = null;
		try {
			getJournalEjb().update(null);
		}
		catch (DomainException e) {
			caught = e;
		}
		assertNotNull("DomainException not thrown", caught);
		assertEquals(DomainExceptionCode.DOMAIN00020, caught.getCode());
	}
	
	@Test
	public void _() {
		Account a = AccountFactory.getAccount();
		a = getAccountEjb().insert(a);
		
		Journal j = JournalFactory.getJournal();
		j.setAccount(a);
		j.setCreatedOn(new Date());
		j.setIsActive(Boolean.TRUE);
		j.setName("mikey");
		
		Journal jj = getJournalEjb().insert(j);
		assertEquals("mikey", jj.getName());
		
		jj.setName("wow");
		jj = getJournalEjb().update(jj);
		assertEquals("wow", jj.getName());
	}
}
