/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.account;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.account.AccountStrategies;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.hibernate.validator.NotNull;

@Entity
@Table(name="account")
public class Account {
    @Transient
    private AccountStrategies strategies = new AccountStrategies();
    @Transient
    private Logger log = Logger.getLogger(this.getClass());
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="username")
    @NotNull
    private String username;
    @Column(name="password")
    @NotNull
    private String password;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        Long min = 0L;
        org.ferris.constraint.NotNull constraint = new org.ferris.constraint.NotNull((Constraint)new GreaterThan((Comparable)min));
        Check check = constraint.check((Object)id);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00005, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00006, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00006, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String email) {
        int max = 50;
        org.ferris.constraint.NotNull constraint = new org.ferris.constraint.NotNull((Constraint)new StringLengthLessThanOrEqualTo(max));
        Check check = constraint.check((Object)email);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00003, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.GreaterThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00004, max, email.length(), email);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.username = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        int max = 50;
        org.ferris.constraint.NotNull constraint = new org.ferris.constraint.NotNull((Constraint)new StringLengthLessThanOrEqualTo(max));
        Check check = constraint.check((Object)password);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00007, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.GreaterThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00008, max, password.length(), password);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.password = password;
    }

    public boolean equals(Object possibleAccount) {
        if (possibleAccount == null) {
            this.log.info((Object)"Parameter possibleAccount is null");
            return false;
        }
        if (!Account.class.isAssignableFrom(possibleAccount.getClass())) {
            this.log.info((Object)("Class " + possibleAccount.getClass().getName() + " not assignable to Account"));
            return false;
        }
        return this.strategies.equals(this, (Account)possibleAccount);
    }

    public String toString() {
        return this.strategies.format(this);
    }

    public int hashCode() {
        return this.strategies.format(this).hashCode();
    }
}

