/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.account;

import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.GreaterThanOrEqualTo;
import org.ferris.constraint.NotNull;
import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.account.AccountLocal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Stateless(name="AccountLocal")
@Local(value={AccountLocal.class})
public class AccountEjb
implements AccountLocal {
    private Logger log = Logger.getLogger(this.getClass());
    @PersistenceContext(unitName="JournalPersistenceUnit")
    private EntityManager entityManager;

    private EntityManager getEntityManager() {
        this.log.info((Object)"Enter: getEntityManager()");
        return this.entityManager;
    }

    public AccountEjb() {
    }

    public AccountEjb(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public Account insert(Account account) {
        this.log.info((Object)("Enter: insert(account) " + account));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)account);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00019, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Persist");
        em.persist((Object)account);
        this.log.info((Object)"Return");
        return this.findId(account.getId());
    }

    @Override
    public Account findId(long id) {
        this.log.info((Object)("Enter: findId(" + id + ")"));
        this.log.info((Object)"Greater than or equal to constraint");
        GreaterThanOrEqualTo constraint = new GreaterThanOrEqualTo((Comparable)Long.valueOf(1L));
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)id);
        if (check != null && check.equals((Object)Check.LessThan)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00001, id, 1);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Find account");
        Account dbData = (Account)em.find(Account.class, (Object)id);
        this.log.info((Object)"Return");
        return dbData;
    }

    @Override
    public Account findUsername(String username) {
        this.log.info((Object)("Enter: findUsername(" + username + ")"));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)username);
        if (check != null) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00002, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Create query");
        Query query = em.createQuery("select account from Account account where username = ?1");
        this.log.info((Object)("Set parameter: " + username));
        query.setParameter(1, (Object)username);
        Account dbData = null;
        try {
            this.log.info((Object)"Run query");
            dbData = (Account)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        this.log.info((Object)"Return");
        return dbData;
    }
}

