/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.journal;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.journal.JournalStrategies;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Entity
@Table(name="journal")
public class Journal {
    @Transient
    private JournalStrategies strategies = new JournalStrategies();
    @Transient
    private Logger log = Logger.getLogger(this.getClass());
    @ManyToOne
    @JoinColumn(name="account_id")
    @org.hibernate.validator.NotNull
    private Account account;
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="created_on")
    @org.hibernate.validator.NotNull
    private Date createdOn;
    @Column(name="name")
    @org.hibernate.validator.NotNull
    private String name;
    @Column(name="is_active")
    @org.hibernate.validator.NotNull
    private Boolean isActive;

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account a) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)a);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00009, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.account = a;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        Long min = 0L;
        NotNull constraint = new NotNull((Constraint)new GreaterThan((Comparable)min));
        Check check = constraint.check((Object)id);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00010, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00011, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00011, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.id = id;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date d) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)d);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00012, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.createdOn = d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        int max = 50;
        NotNull constraint = new NotNull((Constraint)new StringLengthLessThanOrEqualTo(max));
        Check check = constraint.check((Object)s);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00013, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.GreaterThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00014, max, s.length(), s);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.name = s;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean b) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)b);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00015, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.isActive = b;
    }

    public boolean equals(Object possibleJournal) {
        if (possibleJournal == null) {
            this.log.info((Object)"Parameter possibleJournal is null");
            return false;
        }
        if (!(possibleJournal instanceof Journal)) {
            this.log.info((Object)("Class " + possibleJournal.getClass().getName() + " is not assignable to Journal"));
            return false;
        }
        return this.strategies.equals(this, (Journal)possibleJournal);
    }

    public String toString() {
        return this.strategies.format(this);
    }

    public int hashCode() {
        return this.strategies.format(this).hashCode();
    }
}

