/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.journal;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.NotNull;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.JournalLocal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Stateless(name="JournalLocal")
@Local(value={JournalLocal.class})
public class JournalEjb
implements JournalLocal {
    private Logger log = Logger.getLogger(this.getClass());
    @PersistenceContext(unitName="JournalPersistenceUnit")
    private EntityManager entityManager;

    private EntityManager getEntityManager() {
        this.log.info((Object)"Enter: getEntityManager()");
        return this.entityManager;
    }

    public JournalEjb() {
    }

    public JournalEjb(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public Journal insert(Journal journal) {
        this.log.info((Object)("Enter: insert(journal) " + journal));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Contraint check");
        Check check = constraint.check((Object)journal);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00018, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Persist");
        em.persist((Object)journal);
        return this.findById(journal.getAccount().getId(), journal.getId());
    }

    @Override
    public Journal update(Journal journal) throws DomainException {
        this.log.info((Object)("Enter: update(journal) " + journal));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)journal);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00020, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Merge");
        em.merge((Object)journal);
        journal = this.findById(journal.getAccount().getId(), journal.getId());
        this.log.info((Object)"Constraint check");
        check = constraint.check((Object)journal);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00021, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        return journal;
    }

    @Override
    public Journal findById(long accountId, long id) throws DomainException {
        this.log.info((Object)("Enter: findId(" + accountId + "," + id + ")"));
        this.log.info((Object)"Greater than constraint");
        Long min = 0L;
        GreaterThan constraint = new GreaterThan((Comparable)min);
        long x = accountId;
        this.log.info((Object)"Constraint check (accountId)");
        Check check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00022, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00022, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        x = id;
        this.log.info((Object)"Constraint check (id)");
        check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00016, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00016, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.log.info((Object)"Create query");
        Query query = this.getEntityManager().createQuery(" select journal from Journal journal where account.id=?1 and id=?2 ");
        this.log.info((Object)("Set parameter: " + accountId));
        query.setParameter(1, (Object)accountId);
        this.log.info((Object)("Set parameter: " + id));
        query.setParameter(2, (Object)id);
        try {
            this.log.info((Object)"Run query");
            return (Journal)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Journal> findByAccount(long accountId, Boolean isActive) {
        this.log.info((Object)("Enter: findByAccount(" + accountId + "," + isActive + ")"));
        Long min = 0L;
        this.log.info((Object)"Greater than constraint");
        GreaterThan constraint = new GreaterThan((Comparable)min);
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)accountId);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00017, accountId, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00017, accountId, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.log.info((Object)"Create SQL");
        StringBuilder sp = new StringBuilder();
        sp.append(" select journal from Journal journal where ");
        sp.append(" account.id = ?1 ");
        if (isActive != null) {
            sp.append(" and isActive = ?2 ");
        }
        this.log.info((Object)("SQL: " + sp.toString()));
        this.log.info((Object)"Create query");
        Query query = this.getEntityManager().createQuery(sp.toString());
        this.log.info((Object)("Set parameter: " + accountId));
        query.setParameter(1, (Object)accountId);
        if (isActive != null) {
            this.log.info((Object)("Set parameter: " + isActive));
            query.setParameter(2, (Object)isActive);
        }
        ArrayList<Journal> dbData = null;
        try {
            this.log.info((Object)"Run query");
            dbData = query.getResultList();
        }
        catch (NoResultException e) {
            this.log.info((Object)"Query returned no results");
            dbData = new ArrayList<Journal>(0);
        }
        this.log.info((Object)("Return size: " + dbData.size()));
        return dbData;
    }

    @Override
    public Boolean delete(long accountId, long journalId) throws DomainException {
        Journal toDelete;
        this.log.info((Object)("Enter: delete(" + accountId + "," + journalId + ")"));
        this.log.info((Object)"Greater than constraint");
        Long min = 0L;
        GreaterThan constraint = new GreaterThan((Comparable)min);
        long x = accountId;
        this.log.info((Object)"Constraint check (accountId)");
        Check check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00023, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00023, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        x = journalId;
        this.log.info((Object)"Constraint check (journalId)");
        check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00024, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00024, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        if ((toDelete = this.findById(accountId, journalId)) == null) {
            this.log.info((Object)("The entity manager did not find accountId=\"" + accountId + "\" journalId=\"" + journalId + "\" so it cannot be deleted."));
            return false;
        }
        this.log.info((Object)("Deleting: " + toDelete));
        this.getEntityManager().remove((Object)toDelete);
        return true;
    }
}

