/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.journal;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthLessThanOrEqualTo;
import org.ferris.journal.ejb.account.Account;
import org.ferris.journal.ejb.journal.Journal;
import org.ferris.journal.ejb.journal.JournalEntryStrategies;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;

@Entity
@Table(name="journal_entry")
public class JournalEntry {
    @Transient
    private JournalEntryStrategies strategies = new JournalEntryStrategies();
    @Transient
    private Logger log = Logger.getLogger(this.getClass());
    @ManyToOne
    @JoinColumn(name="account_id")
    @org.hibernate.validator.NotNull
    private Account account;
    @ManyToOne
    @JoinColumn(name="journal_id")
    @org.hibernate.validator.NotNull
    private Journal journal;
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="created_on")
    @org.hibernate.validator.NotNull
    private Date createdOn;
    @Column(name="subject")
    @org.hibernate.validator.NotNull
    private String subject;
    @Column(name="entry")
    @org.hibernate.validator.NotNull
    private String entry;
    @Column(name="day")
    @org.hibernate.validator.NotNull
    private Date day;

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account a) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)a);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00025, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.account = a;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal j) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)j);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00026, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.journal = j;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        Long min = 0L;
        NotNull constraint = new NotNull((Constraint)new GreaterThan((Comparable)min));
        Check check = constraint.check((Object)id);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00027, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00028, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00029, id, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.id = id;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date d) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)d);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00030, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.createdOn = d;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String s) {
        int max = 100;
        NotNull constraint = new NotNull((Constraint)new StringLengthLessThanOrEqualTo(max));
        Check check = constraint.check((Object)s);
        if (check != null) {
            if (check.equals((Object)Check.IsNull)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00031, new Object[0]);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.GreaterThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00032, max, s.length(), s);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.subject = s;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String s) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)s);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00033, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.entry = s;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        NotNull constraint = new NotNull();
        Check check = constraint.check((Object)day);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00034, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        this.day = day;
    }

    public boolean equals(Object possibleJournalEntry) {
        if (possibleJournalEntry == null) {
            this.log.info((Object)"Parameter possibleJournalEntry is null");
            return false;
        }
        if (!(possibleJournalEntry instanceof JournalEntry)) {
            this.log.info((Object)("Class " + possibleJournalEntry.getClass().getName() + " is not assignable to JournalEntry"));
            return false;
        }
        return this.strategies.equals(this, (JournalEntry)possibleJournalEntry);
    }

    public String toString() {
        return this.strategies.format(this);
    }

    public int hashCode() {
        return this.strategies.format(this).hashCode();
    }
}

