/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.ejb.journal;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.ferris.constraint.Check;
import org.ferris.constraint.GreaterThan;
import org.ferris.constraint.NotNull;
import org.ferris.journal.ejb.journal.JournalEntry;
import org.ferris.journal.ejb.journal.JournalEntryLocal;
import org.ferris.journal.ejb.lang.DomainException;
import org.ferris.journal.ejb.lang.DomainExceptionCode;
import org.ferris.sql.Like;

@Stateless(name="JournalEntryLocal")
@Local(value={JournalEntryLocal.class})
public class JournalEntryEjb
implements JournalEntryLocal {
    private Logger log = Logger.getLogger(this.getClass());
    @Resource
    private SessionContext sctx;
    @PersistenceContext(unitName="JournalPersistenceUnit")
    private EntityManager entityManager;

    private EntityManager getEntityManager() {
        this.log.info((Object)"Enter: getEntityManager()");
        return this.entityManager;
    }

    public JournalEntryEjb() {
    }

    public JournalEntryEjb(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public JournalEntry findById(long accountId, long id) throws DomainException {
        this.log.info((Object)("Enter: findId(" + accountId + "," + id + ")"));
        this.log.info((Object)"Greater than constraint");
        Long min = 0L;
        GreaterThan constraint = new GreaterThan((Comparable)min);
        long x = accountId;
        this.log.info((Object)"Constraint check (accountId)");
        Check check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00036, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00036, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        x = id;
        this.log.info((Object)"Constraint check (id)");
        check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00037, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00037, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.log.info((Object)"Create query");
        Query query = this.getEntityManager().createQuery(" select journalEntry from JournalEntry journalEntry where account.id=?1 and id=?2 ");
        this.log.info((Object)("Set parameter: " + accountId));
        query.setParameter(1, (Object)accountId);
        this.log.info((Object)("Set parameter: " + id));
        query.setParameter(2, (Object)id);
        try {
            this.log.info((Object)"Run query");
            return (JournalEntry)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Boolean delete(long accountId, long journalEntryId) throws DomainException {
        JournalEntry toDelete;
        this.log.info((Object)("Enter: delete(" + accountId + "," + journalEntryId + ")"));
        this.log.info((Object)"Greater than constraint");
        Long min = 0L;
        GreaterThan constraint = new GreaterThan((Comparable)min);
        long x = accountId;
        this.log.info((Object)"Constraint check (accountId)");
        Check check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00040, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00040, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        x = journalEntryId;
        this.log.info((Object)"Constraint check (journalEntryId)");
        check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00041, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00041, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        if ((toDelete = this.findById(accountId, journalEntryId)) == null) {
            this.log.info((Object)("The entity manager did not find JournalEntry accountId=\"" + accountId + "\" journalId=\"" + journalEntryId + "\" so it cannot be deleted."));
            return false;
        }
        this.log.info((Object)("Deleting: " + toDelete));
        this.getEntityManager().remove((Object)toDelete);
        return true;
    }

    @Override
    public List<JournalEntry> findByJournal(long accountId, long journalId) throws DomainException {
        this.log.info((Object)("Enter: findByJournal(" + accountId + "," + journalId + ")"));
        this.log.info((Object)"Greater than constraint");
        Long min = 0L;
        GreaterThan constraint = new GreaterThan((Comparable)min);
        long x = accountId;
        this.log.info((Object)"Constraint check (accountId)");
        Check check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00042, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00042, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        x = journalId;
        this.log.info((Object)"Constraint check (id)");
        check = constraint.check((Object)x);
        if (check != null) {
            if (check.equals((Object)Check.LessThan)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00043, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
            if (check.equals((Object)Check.EqualToMin)) {
                DomainException e = new DomainException(DomainExceptionCode.DOMAIN00043, x, min);
                this.log.info((Object)e.toString());
                throw e;
            }
        }
        this.log.info((Object)"Create query");
        Query query = this.getEntityManager().createQuery(" select journalEntry from JournalEntry journalEntry where account.id=?1 and journal.id=?2 ");
        this.log.info((Object)("Set parameter: " + accountId));
        query.setParameter(1, (Object)accountId);
        this.log.info((Object)("Set parameter: " + journalId));
        query.setParameter(2, (Object)journalId);
        ArrayList<JournalEntry> dbData = null;
        try {
            this.log.info((Object)"Run query");
            dbData = query.getResultList();
        }
        catch (NoResultException e) {
            this.log.info((Object)"Query returned no results");
            dbData = new ArrayList<JournalEntry>(0);
        }
        this.log.info((Object)("Return size: " + dbData.size()));
        return dbData;
    }

    @Override
    public JournalEntry insert(JournalEntry journalEntry) throws DomainException {
        this.log.info((Object)("Enter: insert(JournalEntry) " + journalEntry));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Contraint check");
        Check check = constraint.check((Object)journalEntry);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00035, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Persist");
        em.persist((Object)journalEntry);
        return this.findById(journalEntry.getAccount().getId(), journalEntry.getId());
    }

    @Override
    public List<JournalEntry> search(long accountId, String keyword, List<Long> journalIds, Date minInclusive, Date maxInclusive) throws DomainException {
        this.log.debug((Object)("Enter: search(" + accountId + "," + keyword + ")"));
        Principal prince = this.sctx.getCallerPrincipal();
        if (prince == null) {
            this.log.info((Object)"&&&&&&&&&&&&&& prince null!");
        } else {
            this.log.info((Object)("%%%%%%%%%%%%%% prince: \"" + prince.getName() + "\""));
        }
        EntityManager em = this.getEntityManager();
        int p = 0;
        StringBuilder sp = new StringBuilder();
        sp.append(" select journalEntry from JournalEntry journalEntry ");
        sp.append(" where ");
        sp.append(" account.id = ?" + ++p);
        if (minInclusive != null) {
            sp.append(" and ");
            sp.append(" day >= ?" + ++p);
        }
        if (maxInclusive != null) {
            sp.append(" and ");
            sp.append(" day <= ?" + ++p);
        }
        if (journalIds != null && journalIds.size() > 0) {
            sp.append(" and ");
            sp.append(" ( ");
            int i = 0;
            for (Long id : journalIds) {
                if (i++ > 0) {
                    sp.append(" or ");
                }
                sp.append(" journal.id = ?" + ++p);
            }
            sp.append(" ) ");
        }
        if (keyword != null && keyword.length() > 0) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" \tupper(subject) like ?" + ++p);
            sp.append(" \tor ");
            sp.append(" \tupper(entry) like ?" + ++p);
            sp.append(" ) ");
        }
        Query query = em.createQuery(sp.toString());
        p = 0;
        query.setParameter(++p, (Object)accountId);
        if (minInclusive != null) {
            query.setParameter(++p, (Object)minInclusive);
        }
        if (maxInclusive != null) {
            query.setParameter(++p, (Object)maxInclusive);
        }
        if (journalIds != null && journalIds.size() > 0) {
            for (Long id : journalIds) {
                query.setParameter(++p, (Object)id);
            }
        }
        if (keyword != null && keyword.length() > 0) {
            String param = "%" + new Like(keyword).getEscapedString().toUpperCase() + "%";
            query.setParameter(++p, (Object)param);
            query.setParameter(++p, (Object)param);
        }
        ArrayList<JournalEntry> dbData = null;
        try {
            this.log.info((Object)"Run query");
            dbData = query.getResultList();
        }
        catch (NoResultException e) {
            this.log.info((Object)"Query returned no results");
            dbData = new ArrayList<JournalEntry>(0);
        }
        this.log.info((Object)("Return size: " + dbData.size()));
        return dbData;
    }

    @Override
    public JournalEntry update(JournalEntry journalEntry) throws DomainException {
        this.log.info((Object)("Enter: update(JournalEntry) " + journalEntry));
        this.log.info((Object)"Not null constraint");
        NotNull constraint = new NotNull();
        this.log.info((Object)"Constraint check");
        Check check = constraint.check((Object)journalEntry);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00038, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        EntityManager em = this.getEntityManager();
        this.log.info((Object)"Merge");
        em.merge((Object)journalEntry);
        journalEntry = this.findById(journalEntry.getAccount().getId(), journalEntry.getId());
        this.log.info((Object)"Constraint check");
        check = constraint.check((Object)journalEntry);
        if (check != null && check.equals((Object)Check.IsNull)) {
            DomainException e = new DomainException(DomainExceptionCode.DOMAIN00039, new Object[0]);
            this.log.info((Object)e.toString());
            throw e;
        }
        return journalEntry;
    }
}

