/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.axis.components.net;

import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.log4j.Logger;

public class MySecureSocketFactory
implements SecureSocketFactory {
    private Logger log = Logger.getLogger(this.getClass());
    private SSLSocketFactory factory;

    public static void main(String[] args) throws Exception {
        new MySecureSocketFactory(new Hashtable());
    }

    public MySecureSocketFactory(Hashtable<? extends Object, ? extends Object> table) throws Exception {
        this.log.info("Get default type");
        String defaultType = KeyStore.getDefaultType();
        this.log.info(String.format("defaultType=\"%s\"", defaultType));
        this.log.info(String.format("Get KeyStore instance", new Object[0]));
        KeyStore ks = KeyStore.getInstance(defaultType);
        String keystore = "/FerrisKeystore";
        this.log.info(String.format("Get class path resource \"%s\"", keystore));
        InputStream is = this.getClass().getResourceAsStream(keystore);
        if (is == null) {
            throw new RuntimeException(String.format("The class path resource \"%s\" is not found!", keystore));
        }
        this.log.info(String.format("Create char[]", new Object[0]));
        char[] password = new char[]{'t', 'o', 'm', 'c', 'a', 't'};
        this.log.info(String.format("Load KeyStore", new Object[0]));
        ks.load(is, password);
        this.log.info(String.format("Loop over KeyStore aliases...", new Object[0]));
        Enumeration<String> enu = ks.aliases();
        while (enu.hasMoreElements()) {
            this.log.info(String.format("Alias=\"%s\"", String.valueOf(enu.nextElement())));
        }
        this.log.info(String.format("Get KeyManagerFactory instance", new Object[0]));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        this.log.info(String.format("Init KeyManagerFactory", new Object[0]));
        kmf.init(ks, password);
        this.log.info(String.format("Get TrustManagerFactory instance", new Object[0]));
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        this.log.info(String.format("Init TrustManagerFactory", new Object[0]));
        tmf.init(ks);
        this.log.info(String.format("Get SSLContext instance", new Object[0]));
        SSLContext context = SSLContext.getInstance("SSL");
        this.log.info(String.format("Init SSLContext", new Object[0]));
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        this.log.info(String.format("Get SocketFactory", new Object[0]));
        this.factory = context.getSocketFactory();
    }

    @Override
    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullUrl) throws Exception {
        this.log.info(String.format("ENTER: create(%s, %d, %s, %s)", host, port, otherHeaders == null ? "null" : otherHeaders.toString(), useFullUrl == null ? "null" : Boolean.valueOf(useFullUrl.value)));
        port = port == -1 ? 443 : port;
        return this.factory.createSocket(host, port);
    }
}

