/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.controller;

import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.swing.JComponent;
import org.ferris.awt.ContainerTools;
import org.ferris.journal.gui.data.JournalEntryData;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.frame.KSearchFrame;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.JComponentTools;
import org.ferris.swing.ui.ThrowableDialog;

public class SearchController {
    private Model model;
    private KSearchFrame view;

    private SearchController setModel(Model model) {
        this.model = model;
        return this;
    }

    private Model getModel() {
        return this.model;
    }

    private SearchController setView() {
        this.view = new KSearchFrame(this, this.getModel());
        return this;
    }

    private KSearchFrame getView() {
        return this.view;
    }

    private SearchController setData() {
        return this;
    }

    public SearchController(Model model) {
        this.setModel(model).setData().setView().getView().setVisible(true);
    }

    public void exit() {
        this.getModel().release();
    }

    public void close() {
        this.getView().setVisible(false);
        this.getView().dispose();
    }

    public void edit(JournalEntry entry) {
        this.model.editJournalEntry(entry);
    }

    public void search(final String keyword, final long[] journalIds, final Calendar minInclusive, final Calendar maxInclusive) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)SearchController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)SearchController.this.view.getJContentPane());
                SearchController.this.model.performingOperation(i18n.getString("op.search.searching", new Object[0]));
                List<JournalEntry> searchResults = JournalEntryData.getInstance().search(SearchController.this.model.getAccount().getId(), keyword, journalIds, minInclusive, maxInclusive);
                SearchController.this.model.performingOperation(i18n.getString("op.search.found", searchResults.size()));
                ContainerTools.setEnabled((Container)SearchController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)SearchController.this.view.getJContentPane());
                SearchController.this.model.setJournalEntrySearchResults(searchResults);
            }
        }.start();
    }

    public void export(final File selectedFile, final List<JournalEntry> entries) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ContainerTools.setEnabled((Container)SearchController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)SearchController.this.view.getJContentPane());
                OutputStream os = null;
                PrintWriter writer = null;
                SimpleDateFormat sdf = new SimpleDateFormat("E, MM/dd/yyyy");
                try {
                    SearchController.this.model.performingOperation(i18n.getString("op.export.os", selectedFile.getName()));
                    os = new FileOutputStream(selectedFile);
                    SearchController.this.model.performingOperation(i18n.getString("op.export.writer", selectedFile.getName()));
                    writer = new PrintWriter(os);
                    int x = 0;
                    for (JournalEntry entry : entries) {
                        SearchController.this.model.performingOperation(i18n.getString("op.export.write", selectedFile.getName(), ++x));
                        writer.println(sdf.format(entry.getDay().getTime()));
                        writer.println(entry.getJournal().getName());
                        writer.println(entry.getSubject());
                        writer.println(entry.getEntry());
                        writer.println("");
                        writer.println("");
                    }
                    writer.flush();
                    writer.close();
                    writer = null;
                    os.close();
                    os = null;
                    SearchController.this.model.performingOperation(i18n.getString("op.export.write.success", selectedFile.getName()));
                }
                catch (Exception e) {
                    SearchController.this.model.performingOperation(i18n.getString("op.export.write.fail", selectedFile.getName()));
                    new ThrowableDialog((Throwable)e, false).setVisible(true);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception ignore) {}
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (Exception ignore) {}
                }
                ContainerTools.setEnabled((Container)SearchController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)SearchController.this.view.getJContentPane());
            }
        }.start();
    }
}

