/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.data;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.ferris.journal.gui.data.AccountData;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.account.AccountJws;
import org.ferris.journal.jws.account.AccountJwsServiceLocator;

public class AccountDataByAxis
extends AccountData {
    private final String $urlstr = "https://ferris.dnsalias.net/journal-jws/bin/account.jws";
    private URL $url;

    private URL getUrl() {
        if (this.$url == null) {
            try {
                this.$url = new URL("https://ferris.dnsalias.net/journal-jws/bin/account.jws");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(i18n.getString("exception.malformed.url", "https://ferris.dnsalias.net/journal-jws/bin/account.jws"));
            }
        }
        return this.$url;
    }

    @Override
    public String test(String echoMeBack) {
        AccountJwsServiceLocator loc = new AccountJwsServiceLocator();
        AccountJws jws = null;
        try {
            jws = loc.getAccountJwsPort(this.getUrl());
            this.setCredentials((Stub)((Object)jws));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        try {
            return jws.test(echoMeBack);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Account register(Account newAccount) {
        AccountJwsServiceLocator loc = new AccountJwsServiceLocator();
        AccountJws jws = null;
        try {
            jws = loc.getAccountJwsPort(this.getUrl());
            this.setCredentials((Stub)((Object)jws));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        try {
            return jws.register(newAccount);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Account login(Account existingAccount) {
        AccountJwsServiceLocator loc = new AccountJwsServiceLocator();
        AccountJws jws = null;
        try {
            jws = loc.getAccountJwsPort(this.getUrl());
            this.setCredentials((Stub)((Object)jws));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        try {
            return jws.login(existingAccount.getUsername(), existingAccount.getPassword());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

