/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.combobox;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.jws.journal.Journal;

public class KJournalComboBoxModel
extends DefaultComboBoxModel
implements JournalObserver {
    private static final long serialVersionUID = -5067783059004831441L;
    private Logger log = Logger.getLogger(this.getClass());
    private Model model;

    private List<Journal> getJournals() {
        return this.model.getActiveJournals();
    }

    private void journalChanged(Journal journal) {
        if (!journal.getIsActive().booleanValue()) {
            this.log.info("Changed journal is NOT active");
        } else {
            this.log.info("Changed journal IS active");
            int newSelectedIndex = this.getJournals().indexOf(journal);
            this.fireContentsChanged(this, newSelectedIndex, newSelectedIndex);
        }
    }

    public KJournalComboBoxModel(Model model) {
        this.model = model;
    }

    @Override
    public Object getElementAt(int index) {
        return this.getJournalAt(index);
    }

    public Journal getJournalAt(int index) {
        return this.getJournals().get(index);
    }

    @Override
    public int getSize() {
        return this.getJournals().size();
    }

    @Override
    public void deletedJournal(Journal deletedJournal) {
        this.log.info("ENTER: deletedJournal()");
        this.fireContentsChanged(this, 0, this.getJournals().size());
        this.log.info("EXIT: deletedJournal()");
    }

    @Override
    public void editJournal(Journal editMe) {
        this.log.info("ENTER: editJournal()");
        this.log.info("EXIT: editJournal()");
    }

    @Override
    public void insertedJournal(Journal newJournal) {
        this.log.info("ENTER: insertedJournal()");
        this.journalChanged(newJournal);
        this.log.info("EXIT: insertedJournal()");
    }

    @Override
    public void newJournal() {
        this.log.info("ENTER: newJournal()");
        this.log.info("EXIT: newJournal()");
    }

    @Override
    public void updatedJournal(Journal updatedJournal) {
        this.log.info("ENTER: updatedJournal()");
        this.journalChanged(updatedJournal);
        this.log.info("EXIT: updatedJournal()");
    }
}

