/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.EntryController;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.JournalEntryObserver;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.ModelForVisualEditor;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KDeleteButton;
import org.ferris.journal.gui.view.button.KNewButton;
import org.ferris.journal.gui.view.button.KSaveButton;
import org.ferris.journal.gui.view.combobox.KJournalComboBox;
import org.ferris.journal.gui.view.combobox.KJournalComboBoxModel;
import org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.editorpane.KEntryTextPane;
import org.ferris.journal.gui.view.frame.KDefaultFrame;
import org.ferris.journal.gui.view.textfield.KEntrySubjectTextField;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public class KEntryFrame
extends KDefaultFrame
implements ActionListener,
ReleaseObserver,
OperationObserver,
WindowFocusListener,
ItemListener,
DocumentListener,
JournalEntryObserver,
JournalObserver {
    private static final long serialVersionUID = 8986611052518547576L;
    private final Logger log = Logger.getLogger(this.getClass());
    private Model model;
    private EntryController controller;
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private KNewButton newButton = null;
    private JPanel buttonPanel = null;
    private KDeleteButton deleteButton = null;
    private KSaveButton saveButton = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JPanel entryPanel = null;
    private JLabel journalLabel = null;
    private JLabel dateLabel = null;
    private JLabel subjectLabel = null;
    private JLabel entryLabel = null;
    private KJournalComboBox journalComboBox = null;
    private KEntrySubjectTextField subjectText = null;
    private KEntryTextPane entryTextPane = null;
    private KEntryDateDatePicker dateDatePicker = null;
    private JMenuBar entryFrameMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitMenuItem = null;
    private JScrollPane entryScrollPane = null;
    private JMenu journalsMenu = null;
    private JMenuItem addEditMenuItem = null;
    private JMenu searchMenu = null;
    private JMenuItem searchMenuItem = null;
    private JournalEntry journalEntryBeingEdited;
    private Date defaultDateDatePickerDate;
    private int focusedGained = 0;

    public KEntryFrame() {
        this.initialize();
    }

    public KEntryFrame(EntryController controller, Model model) {
        this.initialize(controller, model);
    }

    public void initialize(EntryController controller, Model model) {
        this.controller = controller;
        this.model = model;
        this.initialize();
        this.registerObservers();
    }

    private void registerObservers() {
        this.model.registerObserver(this);
        this.model.registerObserver(this);
        this.model.registerObserver(this);
        this.model.registerObserver(this);
    }

    private void removeObservers() {
        this.model.removeObserver(this);
        this.model.removeObserver(this);
        this.model.removeObserver(this);
        this.model.removeObserver(this);
    }

    @Override
    public void dispose() {
        try {
            this.removeObservers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.dispose();
    }

    private void initialize() {
        this.setSize(new Dimension(573, 439));
        this.setJMenuBar(this.getEntryFrameMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setTitle(i18n.getString("entry.frame.title", new Object[0]));
        this.addWindowFocusListener(this);
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridwidth = 1;
            gridBagConstraints21.weighty = 0.0;
            gridBagConstraints21.anchor = 15;
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getMainPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getStatusPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel(" ");
        }
        return this.statusLabel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.mainPanel.add((Component)this.getEntryPanel(), gridBagConstraints1);
        }
        return this.mainPanel;
    }

    private KNewButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new KNewButton();
            this.newButton.addActionListener(this);
        }
        return this.newButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            this.buttonPanel.add((Component)this.getSaveButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
            this.buttonPanel.add((Component)this.getNewButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new KDeleteButton();
            this.deleteButton.setVisible(false);
            this.deleteButton.addActionListener(this);
        }
        return this.deleteButton;
    }

    private KSaveButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new KSaveButton();
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(this);
        }
        return this.saveButton;
    }

    @Override
    public void released() {
        this.log.info("ENTER: relase()");
        System.out.println("Are you sure you want to exit?");
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.statusLabel = this.getStatusLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(flowLayout);
            this.statusPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.statusPanel.add((Component)this.statusLabel, null);
        }
        return this.statusPanel;
    }

    @Override
    public void performingOperation(final String description) {
        InvokeAndWait.run((Runnable)new Runnable(){

            @Override
            public void run() {
                KEntryFrame.this.getStatusLabel().setText(description);
            }
        });
    }

    private JPanel getEntryPanel() {
        if (this.entryPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.fill = 0;
            gridBagConstraints12.insets = new Insets(8, 5, 8, 5);
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 4;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints10.gridx = 0;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 10;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 3;
            this.entryLabel = new JLabel();
            this.entryLabel.setText(i18n.getString("label.entry", new Object[0]));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 2;
            this.subjectLabel = new JLabel();
            this.subjectLabel.setText(i18n.getString("label.subject", new Object[0]));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 1;
            this.dateLabel = new JLabel();
            this.dateLabel.setText(i18n.getString("label.date", new Object[0]));
            this.journalLabel = new JLabel();
            this.journalLabel.setText(i18n.getString("label.journal", new Object[0]));
            this.entryPanel = new JPanel();
            this.entryPanel.setLayout(new GridBagLayout());
            this.entryPanel.add((Component)this.dateLabel, gridBagConstraints12);
            this.entryPanel.add((Component)this.journalLabel, gridBagConstraints4);
            this.entryPanel.add((Component)this.subjectLabel, gridBagConstraints5);
            this.entryPanel.add((Component)this.entryLabel, gridBagConstraints6);
            this.entryPanel.add((Component)this.getJournalComboBox(), gridBagConstraints7);
            this.entryPanel.add((Component)this.getSubjectText(), gridBagConstraints9);
            this.entryPanel.add((Component)((Object)this.getDateDatePicker()), gridBagConstraints8);
            this.entryPanel.add((Component)this.getEntryScrollPane(), gridBagConstraints10);
        }
        return this.entryPanel;
    }

    private KJournalComboBox getJournalComboBox() {
        if (this.journalComboBox == null) {
            if (this.model == null) {
                this.model = new ModelForVisualEditor();
            }
            this.journalComboBox = new KJournalComboBox(new KJournalComboBoxModel(this.model));
            this.journalComboBox.addItemListener(this);
        }
        return this.journalComboBox;
    }

    private KEntrySubjectTextField getSubjectText() {
        if (this.subjectText == null) {
            this.subjectText = new KEntrySubjectTextField();
            this.subjectText.getDocument().addDocumentListener(this);
        }
        return this.subjectText;
    }

    private KEntryTextPane getEntryTextPane() {
        if (this.entryTextPane == null) {
            this.entryTextPane = new KEntryTextPane();
            this.entryTextPane.setPreferredSize(new Dimension(100, 100));
            this.entryTextPane.setSize(new Dimension(100, 198));
            this.entryTextPane.getDocument().addDocumentListener(this);
        }
        return this.entryTextPane;
    }

    private KEntryDateDatePicker getDateDatePicker() {
        if (this.dateDatePicker == null) {
            this.dateDatePicker = new KEntryDateDatePicker();
            this.dateDatePicker.setDate(this.getDefaultDateDatePickerDate());
            this.dateDatePicker.addActionListener(this);
            this.dateDatePicker.getEditor().getDocument().addDocumentListener(this);
            this.dateDatePicker.getEditor().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    KEntryFrame.this.focusedGained = 1;
                    KEntryFrame.this.log.info("Focus gained: " + KEntryFrame.this.focusedGained);
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    KEntryFrame.this.focusedGained = 1;
                    KEntryFrame.this.log.info("Focus lost: " + KEntryFrame.this.focusedGained);
                }
            });
        }
        return this.dateDatePicker;
    }

    private Date getDefaultDateDatePickerDate() {
        return this.defaultDateDatePickerDate == null ? new Date() : this.defaultDateDatePickerDate;
    }

    private JMenuBar getEntryFrameMenuBar() {
        if (this.entryFrameMenuBar == null) {
            this.entryFrameMenuBar = new JMenuBar();
            this.entryFrameMenuBar.add(this.getFileMenu());
            this.entryFrameMenuBar.add(this.getJournalsMenu());
            this.entryFrameMenuBar.add(this.getSearchMenu());
        }
        return this.entryFrameMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText(i18n.getString("file", new Object[0]));
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText(i18n.getString("exit", new Object[0]));
            this.exitMenuItem.setActionCommand("exit");
            this.exitMenuItem.addActionListener(this);
        }
        return this.exitMenuItem;
    }

    private JScrollPane getEntryScrollPane() {
        if (this.entryScrollPane == null) {
            this.entryScrollPane = new JScrollPane();
            this.entryScrollPane.setViewportView(this.getEntryTextPane());
        }
        return this.entryScrollPane;
    }

    private JMenu getJournalsMenu() {
        if (this.journalsMenu == null) {
            this.journalsMenu = new JMenu();
            this.journalsMenu.setText(i18n.getString("journals", new Object[0]));
            this.journalsMenu.add(this.getAddEditMenuItem());
        }
        return this.journalsMenu;
    }

    private JMenuItem getAddEditMenuItem() {
        if (this.addEditMenuItem == null) {
            this.addEditMenuItem = new JMenuItem();
            this.addEditMenuItem.setText(i18n.getString("add_edit", new Object[0]));
            this.addEditMenuItem.setActionCommand("add~edit~journals");
            this.addEditMenuItem.addActionListener(this);
        }
        return this.addEditMenuItem;
    }

    private JMenu getSearchMenu() {
        if (this.searchMenu == null) {
            this.searchMenu = new JMenu();
            this.searchMenu.setText(i18n.getString("search", new Object[0]));
            this.searchMenu.add(this.getSearchMenuItem());
        }
        return this.searchMenu;
    }

    private JMenuItem getSearchMenuItem() {
        if (this.searchMenuItem == null) {
            this.searchMenuItem = new JMenuItem();
            this.searchMenuItem.setText(i18n.getString("search", new Object[0]));
            this.searchMenuItem.setActionCommand("search~search");
            this.searchMenuItem.addActionListener(this);
        }
        return this.searchMenuItem;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.model.registerObserver(this);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.model.removeObserver(this);
    }

    @Override
    public void itemStateChanged(ItemEvent evnt) {
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument().equals(this.getDateDatePicker().getEditor().getDocument())) {
            this.log.info("r fg: " + this.focusedGained);
            if (this.focusedGained == 1) {
                ++this.focusedGained;
                return;
            }
        }
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e.getDocument().equals(this.getDateDatePicker().getEditor().getDocument())) {
            this.log.info("i fg: " + this.focusedGained);
            if (this.focusedGained == 2) {
                ++this.focusedGained;
                return;
            }
        }
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        if ("exit".equals(evnt.getActionCommand())) {
            this.controller.exit();
        } else if ("add~edit~journals".equals(evnt.getActionCommand())) {
            this.controller.addEditJournals();
        } else if ("search~search".equals(evnt.getActionCommand())) {
            this.controller.searchJournalEntries();
        } else if ("datePickerCommit".equals(evnt.getActionCommand())) {
            if (!this.getSaveButton().isEnabled()) {
                this.getSaveButton().setEnabled(true);
            }
        } else if ("save".equals(evnt.getActionCommand())) {
            ArrayList<String> explainations = new ArrayList<String>();
            this.getJournalComboBox().validate(explainations);
            this.getDateDatePicker().validate(explainations);
            this.getSubjectText().validate(explainations);
            this.getEntryTextPane().validate(explainations);
            if (!explainations.isEmpty()) {
                new KErrorDialog(this, explainations);
                return;
            }
            this.defaultDateDatePickerDate = new Date(this.getDateDatePicker().getDate().getTime());
            if (this.journalEntryBeingEdited == null) {
                this.controller.insertEntry(this.getJournalComboBox().getSelectedJournal(), this.getDateDatePicker().getDate(), this.getSubjectText().getText(), this.getEntryTextPane().getText());
            } else {
                this.controller.updateEntry(this.journalEntryBeingEdited.getId(), this.getJournalComboBox().getSelectedJournal(), this.getDateDatePicker().getDate(), this.getSubjectText().getText(), this.getEntryTextPane().getText());
            }
        } else if ("new".equals(evnt.getActionCommand())) {
            this.controller.newEntry();
        } else if ("delete".equals(evnt.getActionCommand())) {
            String msg = i18n.getString("entry.delete.msg", new Object[0]);
            String title = i18n.getString("entry.delete.title", new Object[0]);
            Object[] options = new Object[]{i18n.getString("yes", new Object[0]), i18n.getString("no", new Object[0])};
            int result = JOptionPane.showOptionDialog(this, msg, title, -1, 2, null, options, options[1]);
            this.log.info("Result: " + result);
            if (result == 0) {
                this.controller.deleteEntry(this.journalEntryBeingEdited);
            }
        } else {
            new ThrowableDialog((Throwable)new RuntimeException(i18n.getString("exception.actioncommand.not.recognized", evnt.getActionCommand())), false);
        }
    }

    @Override
    public void insertedJournalEntry(JournalEntry newJournal) {
        this.getDeleteButton().setVisible(true);
        this.getSaveButton().setEnabled(false);
        this.journalEntryBeingEdited = newJournal;
    }

    @Override
    public void updatedJournalEntry(JournalEntry updatedJournal) {
        this.insertedJournalEntry(updatedJournal);
    }

    @Override
    public void newJournalEntry() {
        this.journalEntryBeingEdited = null;
        this.getJournalComboBox().setSelectedIndex(-1);
        this.getJournalComboBox().setBackground(this.getJournalComboBox().getOriginalBackgroundColor());
        this.getDateDatePicker().setDate(this.getDefaultDateDatePickerDate());
        this.getDateDatePicker().setBackground(this.getDateDatePicker().getOriginalBackgroundColor());
        this.getSubjectText().setText("");
        this.getSubjectText().setBackground(this.getSubjectText().getOriginalBackgroundColor());
        this.getEntryTextPane().setText("");
        this.getEntryTextPane().setBackground(this.getEntryTextPane().getOriginalBackgroundColor());
        this.getDeleteButton().setVisible(false);
        this.getSaveButton().setEnabled(false);
        this.getJournalComboBox().grabFocus();
    }

    @Override
    public void deletedJournalEntry(JournalEntry deletedJournal) {
        this.newJournalEntry();
        JOptionPane.showMessageDialog(this, i18n.getString("entry.deleted.dialog.message", new Object[0]), i18n.getString("entry.deleted.dialog.title", new Object[0]), 1);
    }

    @Override
    public void editJournalEntry(JournalEntry editMe) {
        this.journalEntryBeingEdited = editMe;
        this.getJournalComboBox().setSelectedItem(this.journalEntryBeingEdited.getJournal());
        this.getDateDatePicker().setDate(this.journalEntryBeingEdited.getDay().getTime());
        this.getSubjectText().setText(this.journalEntryBeingEdited.getSubject());
        this.getEntryTextPane().setText(this.journalEntryBeingEdited.getEntry());
        this.getEntryTextPane().setCaretPosition(0);
        this.getDeleteButton().setVisible(true);
        this.getSaveButton().setEnabled(false);
        this.getJournalComboBox().grabFocus();
    }

    @Override
    public void deletedJournal(Journal deletedJournal) {
        this.log.info("ENTER: deletedJournal()");
        this.getJournalComboBox().getJournalComboBoxModel().deletedJournal(deletedJournal);
        this.log.info("EXIT: deletedJournal()");
    }

    @Override
    public void editJournal(Journal editMe) {
        this.log.info("ENTER: editJournal()");
        this.getJournalComboBox().getJournalComboBoxModel().editJournal(editMe);
        this.log.info("EXIT: editJournal()");
    }

    @Override
    public void insertedJournal(Journal newJournal) {
        this.log.info("ENTER: insertedJournal()");
        this.getJournalComboBox().getJournalComboBoxModel().insertedJournal(newJournal);
        this.log.info("EXIT: insertedJournal()");
    }

    @Override
    public void newJournal() {
        this.log.info("ENTER: newJournal()");
        this.getJournalComboBox().getJournalComboBoxModel().newJournal();
        this.log.info("EXIT: newJournal()");
    }

    @Override
    public void updatedJournal(Journal updatedJournal) {
        this.log.info("ENTER: updatedJournal()");
        this.getJournalComboBox().getJournalComboBoxModel().updatedJournal(updatedJournal);
        if (!updatedJournal.getIsActive().booleanValue()) {
            this.getJournalComboBox().setSelectedIndex(-1);
        }
        this.log.info("EXIT: updatedJournal()");
    }
}

