/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.JournalsController;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.ModelForVisualEditor;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KCloseButton;
import org.ferris.journal.gui.view.button.KDeleteButton;
import org.ferris.journal.gui.view.button.KNewButton;
import org.ferris.journal.gui.view.button.KSaveButton;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KDefaultFrame;
import org.ferris.journal.gui.view.list.KJournalList;
import org.ferris.journal.gui.view.list.KJournalListModelForAllJournals;
import org.ferris.journal.gui.view.textfield.KJournalNameTextField;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public class KJournalsFrame
extends KDefaultFrame
implements ActionListener,
ReleaseObserver,
OperationObserver,
JournalObserver,
WindowFocusListener,
ListSelectionListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 8986611052518547576L;
    private final Logger log = Logger.getLogger(this.getClass());
    private Model model;
    private JournalsController controller;
    private Journal editing;
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private JButton newButton = null;
    private JPanel buttonPanel = null;
    private JButton saveButton = null;
    private JButton closeButton = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JScrollPane journalsScrollPane = null;
    private KJournalList journalsList = null;
    private JPanel inputPanel = null;
    private JLabel nameLabel = null;
    private KJournalNameTextField nameText = null;
    private JLabel activeLabel = null;
    private JCheckBox activeCheckBox = null;
    private JLabel spacer = null;
    private JSplitPane mainSplitPane = null;
    private JButton deleteButton = null;

    public KJournalsFrame() {
        this.initialize();
    }

    public KJournalsFrame(JournalsController controller, Model model) {
        this.initialize(controller, model);
    }

    public void initialize(JournalsController controller, Model model) {
        this.controller = controller;
        this.model = model;
        this.initialize();
        this.registerObservers();
    }

    @Override
    public void dispose() {
        try {
            this.removeObservers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.dispose();
    }

    private void initialize() {
        this.setSize(new Dimension(432, 286));
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setTitle(i18n.getString("journal.frame.title", new Object[0]));
        this.addWindowFocusListener(this);
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridwidth = 1;
            gridBagConstraints21.weighty = 0.0;
            gridBagConstraints21.anchor = 15;
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getMainPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getStatusPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel(" ");
        }
        return this.statusLabel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 0.0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.mainPanel.add((Component)this.getMainSplitPane(), gridBagConstraints4);
        }
        return this.mainPanel;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new KNewButton();
            this.newButton.addActionListener(this);
        }
        return this.newButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            this.buttonPanel.add((Component)this.getSaveButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
            this.buttonPanel.add((Component)this.getNewButton(), null);
            this.buttonPanel.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new KSaveButton();
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(this);
        }
        return this.saveButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new KCloseButton();
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.statusLabel = this.getStatusLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(flowLayout);
            this.statusPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.statusPanel.add((Component)this.statusLabel, null);
        }
        return this.statusPanel;
    }

    private JScrollPane getJournalsScrollPane() {
        if (this.journalsScrollPane == null) {
            this.journalsScrollPane = new JScrollPane();
            this.journalsScrollPane.setViewportView(this.getJournalsList());
        }
        return this.journalsScrollPane;
    }

    private KJournalList getJournalsList() {
        if (this.journalsList == null) {
            if (this.model == null) {
                this.model = new ModelForVisualEditor();
            }
            this.journalsList = new KJournalList(new KJournalListModelForAllJournals(this.model));
            this.journalsList.addListSelectionListener(this);
        }
        return this.journalsList;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.gridy = 2;
            this.spacer = new JLabel();
            this.spacer.setText("   ");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints8.weighty = 0.0;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridy = 1;
            this.activeLabel = new JLabel();
            this.activeLabel.setText("Active :");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints6.gridy = 0;
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name :");
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.add((Component)this.nameLabel, gridBagConstraints6);
            this.inputPanel.add((Component)this.getNameText(), gridBagConstraints7);
            this.inputPanel.add((Component)this.activeLabel, gridBagConstraints8);
            this.inputPanel.add((Component)this.getActiveCheckBox(), gridBagConstraints9);
            this.inputPanel.add((Component)this.spacer, gridBagConstraints10);
        }
        return this.inputPanel;
    }

    private KJournalNameTextField getNameText() {
        if (this.nameText == null) {
            this.nameText = new KJournalNameTextField();
            this.nameText.getDocument().addDocumentListener(this);
        }
        return this.nameText;
    }

    private JCheckBox getActiveCheckBox() {
        if (this.activeCheckBox == null) {
            this.activeCheckBox = new JCheckBox();
            this.activeCheckBox.setSelected(true);
            this.activeCheckBox.addItemListener(this);
        }
        return this.activeCheckBox;
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setDividerSize(8);
            this.mainSplitPane.setResizeWeight(0.0);
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setDividerLocation(150);
            this.mainSplitPane.setRightComponent(this.getInputPanel());
            this.mainSplitPane.setLeftComponent(this.getJournalsScrollPane());
        }
        return this.mainSplitPane;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new KDeleteButton();
            this.deleteButton.addActionListener(this);
            this.deleteButton.setVisible(false);
        }
        return this.deleteButton;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.model.registerObserver(this);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.model.removeObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.log.info("ENTER: valueChanged()");
        int selectedIndex = this.getJournalsList().getSelectedIndex();
        this.log.info("Now selected: " + selectedIndex);
        if (selectedIndex >= 0) {
            final Journal selectedJournal = this.getJournalsList().getJournalListModel().getJournalAt(selectedIndex);
            Thread t = new Thread(){

                @Override
                public void run() {
                    KJournalsFrame.this.setEditing(selectedJournal);
                }
            };
            t.start();
        }
        this.log.info("EXIT: valueChanged()");
    }

    @Override
    public void released() {
        this.log.info("ENTER: relase()");
        System.out.println("Are you sure you want to exit?");
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        if ("close".equals(evnt.getActionCommand())) {
            this.controller.closeFrame();
        } else if ("new".equals(evnt.getActionCommand())) {
            this.controller.newJournal();
        } else if ("delete".equals(evnt.getActionCommand())) {
            String msg = i18n.getString("journal.delete.msg", new Object[0]);
            String title = i18n.getString("journal.delete.title", new Object[0]);
            Object[] options = new Object[]{i18n.getString("yes", new Object[0]), i18n.getString("no", new Object[0])};
            int result = JOptionPane.showOptionDialog(this, msg, title, -1, 2, null, options, options[1]);
            this.log.info("Result: " + result);
            if (result == 0) {
                Journal j = (Journal)this.getJournalsList().getSelectedValue();
                this.controller.deleteJournal(j);
            }
        } else if ("save".equals(evnt.getActionCommand())) {
            ArrayList<String> explainations = new ArrayList<String>();
            this.getNameText().validate(explainations);
            if (!explainations.isEmpty()) {
                new KErrorDialog(this, explainations);
                return;
            }
            if (this.editing == null) {
                this.controller.insertJournal(this.getNameText().getText(), this.getActiveCheckBox().isSelected());
            } else {
                this.controller.updateJournal(this.editing.getId(), this.getNameText().getText(), this.getActiveCheckBox().isSelected());
            }
        } else {
            new ThrowableDialog((Throwable)new RuntimeException(i18n.getString("exception.actioncommand.not.recognized", evnt.getActionCommand())), false);
        }
    }

    @Override
    public void deletedJournal(Journal deletedJournl) {
        this.log.info("ENTER: deletedJournal()");
        this.getJournalsList().getJournalListModel().deletedJournal(deletedJournl);
        this.setEditing(null);
        this.log.info("EXIT: deletedJournal()");
    }

    @Override
    public void insertedJournal(Journal newJournal) {
        this.log.info("ENTER: insertedJournal()");
        Long setSelected = newJournal.getId();
        this.log.info("ID of new journal: " + setSelected);
        this.getJournalsList().getJournalListModel().insertedJournal(newJournal);
        this.getJournalsList().setSelectedValue(newJournal, true);
        this.log.info("EXIT: insertedJournal()");
    }

    @Override
    public void updatedJournal(Journal updatedJournal) {
        this.log.info("ENTER: updatedJournal()");
        Long setSelected = updatedJournal.getId();
        this.log.info("ID of updated journal: " + setSelected);
        this.getJournalsList().getJournalListModel().updatedJournal(updatedJournal);
        this.getJournalsList().setSelectedValue(updatedJournal, true);
        this.log.info("EXIT: updatedJournal()");
    }

    @Override
    public void editJournal(Journal editMe) {
        this.log.info("ENTER: editJournal()");
        this.setEditing(editMe);
        this.log.info("EXIT: editJournal()");
    }

    @Override
    public void newJournal() {
        this.log.info("ENTER: newJournal()");
        this.setEditing(null);
        this.log.info("EXIT: newJournal()");
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.getSaveButton().isEnabled()) {
            this.getSaveButton().setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        switch (e.getStateChange()) {
            case 1: 
            case 2: {
                this.log.info("*** Enable save: itemStateChanged");
                if (this.getSaveButton().isEnabled()) break;
                this.getSaveButton().setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void performingOperation(final String description) {
        InvokeAndWait.run((Runnable)new Runnable(){

            @Override
            public void run() {
                KJournalsFrame.this.getStatusLabel().setText(description);
            }
        });
    }

    private void registerObservers() {
        this.model.registerObserver(this);
        this.model.registerObserver(this);
        this.model.registerObserver(this);
    }

    private void removeObservers() {
        this.model.removeObserver(this);
        this.model.removeObserver(this);
        this.model.removeObserver(this);
    }

    private void setEditing(Journal selectedJournal) {
        this.log.info("ENTER: setEditing()");
        this.editing = selectedJournal;
        if (selectedJournal != null) {
            this.getNameText().getDocument().removeDocumentListener(this);
            this.getNameText().setText(selectedJournal.getName());
            this.getNameText().setSelectionStart(0);
            this.getNameText().setSelectionEnd(this.getNameText().getText().length());
            this.getNameText().grabFocus();
            this.getNameText().getDocument().addDocumentListener(this);
            this.getActiveCheckBox().removeItemListener(this);
            this.getActiveCheckBox().setSelected(selectedJournal.getIsActive());
            this.getActiveCheckBox().addItemListener(this);
            this.getDeleteButton().setVisible(true);
            this.log.info("Disable save button");
            this.getSaveButton().setEnabled(false);
        } else {
            this.getNameText().getDocument().removeDocumentListener(this);
            this.getNameText().setText("");
            this.getNameText().grabFocus();
            this.getNameText().getDocument().addDocumentListener(this);
            this.getActiveCheckBox().removeItemListener(this);
            this.getActiveCheckBox().setSelected(true);
            this.getActiveCheckBox().addItemListener(this);
            this.getDeleteButton().setVisible(false);
            this.log.info("Disable save and set selected index");
            this.getSaveButton().setEnabled(false);
            this.getJournalsList().clearSelection();
        }
        this.log.info("EXIT: setEditing()");
    }
}

