/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.ferris.journal.gui.controller.LoginController;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KExitButton;
import org.ferris.journal.gui.view.button.KLoginButton;
import org.ferris.journal.gui.view.button.KRegisterButton;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KDefaultFrame;
import org.ferris.journal.gui.view.panel.KCredentialsPanel;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public class KLoginFrame
extends KDefaultFrame
implements ActionListener,
ReleaseObserver,
OperationObserver {
    private static final long serialVersionUID = 8986611052518547576L;
    private Model model;
    private LoginController controller;
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private KCredentialsPanel credentialsPanel = null;
    private JButton loginButton = null;
    private JPanel buttonPanel = null;
    private JButton registerButton = null;
    private KExitButton exitButton = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;

    public KLoginFrame() {
        this.initialize();
    }

    public KLoginFrame(LoginController controller, Model model) {
        this.initialize(controller, model);
    }

    public void initialize(LoginController controller, Model model) {
        this.controller = controller;
        this.model = model;
        this.initialize();
        this.model.registerObserver(this);
        this.model.registerObserver(this);
    }

    @Override
    public void dispose() {
        try {
            this.model.removeObserver(this);
            this.model.removeObserver(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.dispose();
    }

    private void initialize() {
        this.setSize(new Dimension(390, 178));
        this.setContentPane(this.getJContentPane());
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setTitle(i18n.getString("login.frame.title", new Object[0]));
        this.setAlwaysOnTop(true);
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(" ");
        }
        return this.statusLabel;
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridwidth = 2;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.anchor = 15;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getMainPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getStatusPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridy = 0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.mainPanel.add((Component)this.getCredentialsPanel(), gridBagConstraints1);
        }
        return this.mainPanel;
    }

    private KCredentialsPanel getCredentialsPanel() {
        if (this.credentialsPanel == null) {
            this.credentialsPanel = new KCredentialsPanel();
        }
        return this.credentialsPanel;
    }

    private JButton getLoginButton() {
        if (this.loginButton == null) {
            this.loginButton = new KLoginButton();
            this.loginButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.loginButton);
        }
        return this.loginButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            this.buttonPanel.add((Component)this.getLoginButton(), null);
            this.buttonPanel.add((Component)this.getRegisterButton(), null);
            this.buttonPanel.add((Component)this.getExitButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getRegisterButton() {
        if (this.registerButton == null) {
            this.registerButton = new KRegisterButton();
            this.registerButton.addActionListener(this);
        }
        return this.registerButton;
    }

    private KExitButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new KExitButton();
            this.exitButton.addActionListener(this);
        }
        return this.exitButton;
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        if ("exit".equals(evnt.getActionCommand())) {
            this.controller.exit();
        } else if ("register".equals(evnt.getActionCommand())) {
            String repeatedPassword;
            ArrayList<String> errors = new ArrayList<String>();
            this.getCredentialsPanel().validate(errors);
            if (!errors.isEmpty()) {
                new KErrorDialog(this, errors);
                return;
            }
            JPasswordField pwd = new JPasswordField(10);
            pwd.grabFocus();
            int action = JOptionPane.showConfirmDialog(this, pwd, i18n.getString("confirm_password", new Object[0]), 2);
            String string = repeatedPassword = action == 0 ? new String(pwd.getPassword()) : null;
            if (repeatedPassword != null) {
                if (!Arrays.equals(this.getCredentialsPanel().getPassword(), repeatedPassword.toCharArray())) {
                    errors.add(i18n.getString("password_mismatch", new Object[0]));
                    new KErrorDialog(this, errors);
                    this.getRegisterButton().doClick();
                    return;
                }
                this.controller.register(this.getCredentialsPanel().getUsername(), this.getCredentialsPanel().getPassword());
                return;
            }
        } else if ("login".equals(evnt.getActionCommand())) {
            ArrayList<String> errors = new ArrayList<String>();
            this.getCredentialsPanel().validate(errors);
            if (!errors.isEmpty()) {
                new KErrorDialog(this, errors);
                return;
            }
            System.out.println(errors);
            this.controller.login(this.getCredentialsPanel().getUsername(), this.getCredentialsPanel().getPassword());
        } else {
            new ThrowableDialog((Throwable)new RuntimeException(i18n.getString("exception.actioncommand.not.recognized", evnt.getActionCommand())), false);
        }
    }

    @Override
    public void released() {
        System.out.println("Are you sure you want to exit?");
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.statusLabel = this.getStatusLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(flowLayout);
            this.statusPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.statusPanel.add((Component)this.statusLabel, null);
        }
        return this.statusPanel;
    }

    @Override
    public void performingOperation(final String description) {
        InvokeAndWait.run((Runnable)new Runnable(){

            @Override
            public void run() {
                KLoginFrame.this.getStatusLabel().setText(description);
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        InvokeAndWait.run((Runnable)new Runnable(){

            @Override
            public void run() {
                if (KLoginFrame.this.getCredentialsPanel().getUsername() != null && KLoginFrame.this.getCredentialsPanel().getUsername().length() > 0) {
                    KLoginFrame.this.getCredentialsPanel().focusOnPassword();
                }
            }
        });
    }
}

