/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.frame;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.controller.SearchController;
import org.ferris.journal.gui.data.JournalEntryComparator;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.JournalEntryObserver;
import org.ferris.journal.gui.model.JournalEntrySearchObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.ModelForVisualEditor;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.gui.view.button.KCloseButton;
import org.ferris.journal.gui.view.button.KEditButton;
import org.ferris.journal.gui.view.button.KExportAsTextButton;
import org.ferris.journal.gui.view.button.KSearchButton;
import org.ferris.journal.gui.view.datepicker.KEntryDateDatePicker;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KDefaultFrame;
import org.ferris.journal.gui.view.list.KJournalList;
import org.ferris.journal.gui.view.list.KJournalListModelForAllJournals;
import org.ferris.journal.gui.view.table.KEntryTable;
import org.ferris.journal.gui.view.table.KEntryTableModel;
import org.ferris.journal.gui.view.textfield.KKeywordTextField;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.ui.ThrowableDialog;

public class KSearchFrame
extends KDefaultFrame
implements ActionListener,
ReleaseObserver,
OperationObserver,
JournalEntryObserver,
JournalEntrySearchObserver,
WindowFocusListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 8986611052518547576L;
    private final Logger log = Logger.getLogger(this.getClass());
    private Model model;
    private SearchController controller;
    private Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private JButton searchButton = null;
    private JButton closeButton = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JPanel inputPanel = null;
    private JLabel keywordLabel = null;
    private KKeywordTextField keywordText = null;
    private JLabel journalListLabel = null;
    private JLabel spacer = null;
    private JScrollPane entryTableScrollPane = null;
    private KEntryTable entryTable = null;
    private KEditButton editButton = null;
    private KExportAsTextButton exportButton = null;
    private JScrollPane journalsScrollPane = null;
    private KJournalList journalList = null;
    private JLabel dateRangeLabel = null;
    private JPanel dateRangePanel = null;
    private KEntryDateDatePicker minDateDatePicker = null;
    private JLabel toLabel = null;
    private KEntryDateDatePicker maxDateDatePicker = null;

    public KSearchFrame() {
        this.initialize();
    }

    public KSearchFrame(SearchController controller, Model model) {
        this.initialize(controller, model);
    }

    public void initialize(SearchController controller, Model model) {
        this.controller = controller;
        this.model = model;
        this.initialize();
        this.registerObservers(false);
    }

    @Override
    public void dispose() {
        try {
            this.removeObservers(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.dispose();
    }

    private void initialize() {
        this.setSize(new Dimension(623, 394));
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setTitle(i18n.getString("search.frame.title", new Object[0]));
        this.addWindowFocusListener(this);
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.gridwidth = 1;
            gridBagConstraints21.weighty = 0.0;
            gridBagConstraints21.anchor = 15;
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getMainPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getStatusPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel(" ");
        }
        return this.statusLabel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.anchor = 10;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = -1;
            gridBagConstraints5.gridy = -1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.weighty = 0.0;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 0.0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.mainPanel.add((Component)this.getInputPanel(), gridBagConstraints4);
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(8, 5, 8, 5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            this.buttonPanel.add((Component)this.getSearchButton(), null);
            this.buttonPanel.add((Component)this.getEditButton(), null);
            this.buttonPanel.add((Component)this.getExportButton(), null);
            this.buttonPanel.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new KSearchButton();
            this.searchButton.setEnabled(false);
            this.searchButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.searchButton);
        }
        return this.searchButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new KCloseButton();
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(0);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(0);
            this.statusLabel = this.getStatusLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(flowLayout);
            this.statusPanel.setBorder(BorderFactory.createBevelBorder(1));
            this.statusPanel.add((Component)this.statusLabel, null);
        }
        return this.statusPanel;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints13.gridy = 1;
            this.dateRangeLabel = new JLabel();
            this.dateRangeLabel.setText("Dates :");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 0.5;
            gridBagConstraints9.insets = new Insets(8, 5, 0, 5);
            gridBagConstraints9.anchor = 11;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 1;
            gridBagConstraints12.gridy = 4;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.weighty = 1.0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.anchor = 10;
            gridBagConstraints12.gridx = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.weighty = 0.0;
            gridBagConstraints10.gridy = 3;
            this.spacer = new JLabel();
            this.spacer.setText("   ");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 11;
            gridBagConstraints8.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints8.weighty = 0.0;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridy = 2;
            this.journalListLabel = new JLabel();
            this.journalListLabel.setText("Journals :");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(8, 5, 8, 5);
            gridBagConstraints6.gridy = 0;
            this.keywordLabel = new JLabel();
            this.keywordLabel.setText("Keyword :");
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.add((Component)this.keywordLabel, gridBagConstraints6);
            this.inputPanel.add((Component)this.getKeywordText(), gridBagConstraints7);
            this.inputPanel.add((Component)this.journalListLabel, gridBagConstraints8);
            this.inputPanel.add((Component)this.spacer, gridBagConstraints10);
            this.inputPanel.add((Component)this.getEntryTableScrollPane(), gridBagConstraints12);
            this.inputPanel.add((Component)this.getJournalsScrollPane(), gridBagConstraints9);
            this.inputPanel.add((Component)this.dateRangeLabel, gridBagConstraints13);
            this.inputPanel.add((Component)this.getDateRangePanel(), gridBagConstraints14);
        }
        return this.inputPanel;
    }

    private KKeywordTextField getKeywordText() {
        if (this.keywordText == null) {
            this.keywordText = new KKeywordTextField();
            this.keywordText.getDocument().addDocumentListener(this);
        }
        return this.keywordText;
    }

    private JScrollPane getEntryTableScrollPane() {
        if (this.entryTableScrollPane == null) {
            this.entryTableScrollPane = new JScrollPane();
            this.entryTableScrollPane.setViewportView(this.getEntryTable());
        }
        return this.entryTableScrollPane;
    }

    private KEntryTable getEntryTable() {
        if (this.entryTable == null) {
            this.entryTable = new KEntryTable(new KEntryTableModel(new ArrayList<JournalEntry>()));
            this.entryTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        KSearchFrame.this.getEditButton().doClick();
                    }
                }
            });
        }
        return this.entryTable;
    }

    private KEditButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new KEditButton();
            this.editButton.setEnabled(true);
            this.editButton.addActionListener(this);
        }
        return this.editButton;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.registerObservers(true);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.removeObservers(true);
    }

    @Override
    public void released() {
        this.log.info("ENTER: relase()");
        System.out.println("Are you sure you want to exit?");
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        if ("close".equals(evnt.getActionCommand())) {
            this.controller.close();
        } else if ("edit".equals(evnt.getActionCommand())) {
            JournalEntry selected = this.getEntryTable().getSelectedEntry();
            if (selected == null) {
                return;
            }
            this.controller.edit(selected);
        } else if ("exportAsText".equals(evnt.getActionCommand())) {
            if (this.getEntryTable().getRowCount() > 0) {
                int jfcRes;
                String lastDirectory = this.getPreference("exportSearchToDirectory");
                String lastFile = this.getPreference("exportSearchToFile");
                JFileChooser jfc = new JFileChooser(lastDirectory);
                if (lastFile != null) {
                    jfc.setSelectedFile(new File(lastFile));
                }
                if (0 == (jfcRes = jfc.showSaveDialog(this))) {
                    this.setPreference("exportSearchToDirectory", jfc.getSelectedFile().getParent());
                    this.setPreference("exportSearchToFile", jfc.getSelectedFile().getName());
                    this.controller.export(jfc.getSelectedFile(), this.getEntryTable().getEntryTableModel().getEntries());
                }
            }
        } else if ("datePickerCommit".equals(evnt.getActionCommand())) {
            if (!this.getSearchButton().isEnabled()) {
                this.getSearchButton().setEnabled(true);
            }
        } else if ("search".equals(evnt.getActionCommand())) {
            List<String> explainations = this.validateInput();
            if (!explainations.isEmpty()) {
                new KErrorDialog(this, explainations);
                return;
            }
            List<Journal> journals = this.getJournalList().getSelectedJournals();
            long[] journalIds = null;
            if (journals != null && !journals.isEmpty()) {
                journalIds = new long[journals.size()];
                int i = 0;
                for (Journal j : journals) {
                    journalIds[i++] = j.getId();
                }
            }
            Calendar min = null;
            if (this.getMinDateDatePicker().getDate() != null) {
                min = Calendar.getInstance();
                min.setTime(this.getMinDateDatePicker().getDate());
            }
            Calendar max = null;
            if (this.getMaxDateDatePicker().getDate() != null) {
                max = Calendar.getInstance();
                max.setTime(this.getMaxDateDatePicker().getDate());
            }
            this.controller.search(this.getKeywordText().getText(), journalIds, min, max);
        } else {
            new ThrowableDialog((Throwable)new RuntimeException(i18n.getString("exception.actioncommand.not.recognized", evnt.getActionCommand())), false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.getSearchButton().isEnabled()) {
            this.getSearchButton().setEnabled(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.getSearchButton().isEnabled()) {
            this.getSearchButton().setEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.getSearchButton().isEnabled()) {
            this.getSearchButton().setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        switch (e.getStateChange()) {
            case 1: 
            case 2: {
                this.log.info("*** Enable save: itemStateChanged");
                if (this.getSearchButton().isEnabled()) break;
                this.getSearchButton().setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void performingOperation(final String description) {
        InvokeAndWait.run((Runnable)new Runnable(){

            @Override
            public void run() {
                KSearchFrame.this.getStatusLabel().setText(description);
            }
        });
    }

    private void registerObservers(boolean focusChange) {
        if (!focusChange) {
            this.model.registerObserver(this);
            this.model.registerObserver(this);
            this.model.registerObserver(this);
            this.model.registerObserver(this);
        } else {
            this.model.registerObserver(this);
            this.model.registerObserver(this);
        }
    }

    private void removeObservers(boolean focusChange) {
        if (!focusChange) {
            this.model.removeObserver(this);
            this.model.removeObserver(this);
            this.model.removeObserver(this);
            this.model.removeObserver(this);
        } else {
            this.model.removeObserver(this);
            this.model.removeObserver(this);
        }
    }

    private List<String> validateInput() {
        ArrayList<String> explainations = new ArrayList<String>();
        this.getKeywordText().validate(explainations);
        if (this.getMinDateDatePicker().getDate() != null && this.getMaxDateDatePicker().getDate() != null && this.getMinDateDatePicker().getDate().getTime() > this.getMaxDateDatePicker().getDate().getTime()) {
            explainations.add(i18n.getString("search.date.malformed.mingtmax", new Object[0]));
        }
        if (explainations.isEmpty()) {
            boolean missing;
            List<Journal> journals = this.getJournalList().getSelectedJournals();
            boolean bl = missing = this.getKeywordText().getText().length() == 0 && journals.size() == 0 && this.getMinDateDatePicker().getDate() == null && this.getMaxDateDatePicker().getDate() == null;
            if (missing) {
                explainations.add(i18n.getString("search.malformed.required", new Object[0]));
            }
        }
        return explainations;
    }

    private String getPreference(String key) {
        String pref = this.prefs.get("KSearchFrame." + key, null);
        return pref;
    }

    private void setPreference(String key, String pref) {
        this.prefs.put("KSearchFrame." + key, pref);
        try {
            this.prefs.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void results(List<JournalEntry> results) {
        Collections.sort(results, JournalEntryComparator.DAY_ASC);
        this.getEntryTable().setEntries(results);
        this.getKeywordText().setSelectionStart(0);
        this.getKeywordText().setSelectionEnd(this.getKeywordText().getText().length());
        this.getKeywordText().grabFocus();
    }

    @Override
    public void deletedJournalEntry(JournalEntry deletedJournal) {
        this.getEntryTable().deleteEntry(deletedJournal);
        this.getStatusLabel().setText(i18n.getString("op.search.found", this.getEntryTable().getRowCount()));
    }

    @Override
    public void editJournalEntry(JournalEntry editMe) {
    }

    @Override
    public void insertedJournalEntry(JournalEntry newJournal) {
        String s = this.getKeywordText().getText();
        if (s == null) {
            s = "";
        }
        if (s != null) {
            s = s.trim();
        }
        if (s.length() > 0) {
            boolean contains;
            String keywordUppercase = this.getKeywordText().getText().toUpperCase();
            boolean bl = contains = newJournal.getSubject().toUpperCase().contains(keywordUppercase) || newJournal.getEntry().toUpperCase().contains(keywordUppercase);
            if (contains) {
                this.getEntryTable().addEntry(newJournal);
                this.getStatusLabel().setText(i18n.getString("op.search.found", this.getEntryTable().getRowCount()));
            }
        }
    }

    @Override
    public void newJournalEntry() {
    }

    @Override
    public void updatedJournalEntry(JournalEntry updatedJournal) {
        this.getEntryTable().updateEntry(updatedJournal);
    }

    private KExportAsTextButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new KExportAsTextButton();
            this.exportButton.setEnabled(true);
            this.exportButton.addActionListener(this);
        }
        return this.exportButton;
    }

    private JScrollPane getJournalsScrollPane() {
        if (this.journalsScrollPane == null) {
            this.journalsScrollPane = new JScrollPane();
            this.journalsScrollPane.setViewportView(this.getJournalList());
        }
        return this.journalsScrollPane;
    }

    private KJournalList getJournalList() {
        if (this.journalList == null) {
            if (this.model == null) {
                this.model = new ModelForVisualEditor();
            }
            this.journalList = new KJournalList(new KJournalListModelForAllJournals(this.model));
            this.journalList.setSelectionMode(2);
            this.journalList.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        KSearchFrame.this.journalList.clearSelection();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.journalList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && !KSearchFrame.this.getSearchButton().isEnabled()) {
                        KSearchFrame.this.getSearchButton().setEnabled(KSearchFrame.this.journalList.getSelectedJournals().size() > 0);
                    }
                }
            });
        }
        return this.journalList;
    }

    private JPanel getDateRangePanel() {
        if (this.dateRangePanel == null) {
            FlowLayout flowLayout1 = new FlowLayout(0);
            flowLayout1.setVgap(5);
            this.toLabel = new JLabel();
            this.toLabel.setText("to");
            this.dateRangePanel = new JPanel();
            this.dateRangePanel.setLayout(flowLayout1);
            this.dateRangePanel.add((Component)((Object)this.getMinDateDatePicker()), null);
            this.dateRangePanel.add((Component)this.toLabel, null);
            this.dateRangePanel.add((Component)((Object)this.getMaxDateDatePicker()), null);
        }
        return this.dateRangePanel;
    }

    private KEntryDateDatePicker getMinDateDatePicker() {
        if (this.minDateDatePicker == null) {
            this.minDateDatePicker = new KEntryDateDatePicker();
            this.minDateDatePicker.getEditor().getDocument().addDocumentListener(this);
            this.minDateDatePicker.addActionListener(this);
        }
        return this.minDateDatePicker;
    }

    private KEntryDateDatePicker getMaxDateDatePicker() {
        if (this.maxDateDatePicker == null) {
            this.maxDateDatePicker = new KEntryDateDatePicker();
            this.maxDateDatePicker.getEditor().getDocument().addDocumentListener(this);
            this.maxDateDatePicker.addActionListener(this);
        }
        return this.maxDateDatePicker;
    }
}

