/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.images;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImageFactory {
    private static Logger log = Logger.getLogger(ImageFactory.class);
    private static String packageName;
    private static Image applicationIcon;
    private static Icon textFileIcon;

    private static String getPackageName() {
        log.info(String.format("ENTER: getPackageName()", new Object[0]));
        if (packageName == null) {
            packageName = "/";
        }
        log.info(String.format("packageName=\"%s\"", packageName));
        return packageName;
    }

    private static Image getImage(String imageName) {
        log.info(String.format("ENTER: getImage(\"%s\")", imageName));
        return Toolkit.getDefaultToolkit().createImage(ImageFactory.class.getResource(ImageFactory.getPackageName() + imageName));
    }

    private static Icon getIcon(String imageName) {
        log.info(String.format("ENTER: getIcon(\"%s\")", imageName));
        URL imgURL = ImageFactory.class.getResource(ImageFactory.getPackageName() + imageName);
        log.info(String.format("imgURL=", String.valueOf(imgURL)));
        return new ImageIcon(imgURL);
    }

    public static Image getApplicationIcon() {
        log.info(String.format("ENTER: getApplicationIcon()", new Object[0]));
        if (applicationIcon == null) {
            applicationIcon = ImageFactory.getImage("FerrisPencilIcon.gif");
        }
        return applicationIcon;
    }

    public static Icon getTextFileIcon() {
        log.info(String.format("ENTER: getTextFileIcon()", new Object[0]));
        if (textFileIcon == null) {
            textFileIcon = ImageFactory.getIcon("FerrisTextfileIcon.gif");
        }
        return textFileIcon;
    }
}

