/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.table;

import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.view.table.KEntryTableModel;
import org.ferris.journal.jws.journalentry.JournalEntry;

public class KEntryTable
extends JTable {
    private Logger log = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 1826009857640983576L;
    int x = 0;

    public KEntryTable(KEntryTableModel dm) {
        super(dm);
        this.setSelectionMode(0);
        try {
            String ver = System.getProperty("java.vm.version");
            this.log.info("Version: " + ver);
            ver = ver.substring(0, 3);
            this.log.info("Version: " + ver);
            double d = Double.parseDouble(ver);
            this.log.info("Version: " + d);
            if (d >= 1.6) {
                Method m = this.getClass().getMethod("setAutoCreateRowSorter", Boolean.TYPE);
                m.invoke((Object)this, true);
            }
        }
        catch (Exception ignore) {
            this.log.error("oops", ignore);
        }
    }

    public KEntryTableModel getEntryTableModel() {
        return (KEntryTableModel)this.getModel();
    }

    public KEntryTable setEntries(List<JournalEntry> entries) {
        this.getEntryTableModel().setEntries(entries);
        return this;
    }

    public JournalEntry getSelectedEntry() {
        int i = this.getSelectedRow();
        JournalEntry retval = null;
        if (i >= 0) {
            retval = this.getEntryTableModel().getEntries().get(i);
        }
        return retval;
    }

    public void deleteEntry(JournalEntry deletedJournal) {
        int idx = this.getSelectedRow();
        int u = this.getEntryTableModel().deleteEntry(deletedJournal);
        if (u != -1 && idx != -1) {
            if (idx >= this.getEntryTableModel().getEntries().size()) {
                idx = this.getEntryTableModel().getEntries().size() - 1;
            }
            this.addRowSelectionInterval(idx, idx);
        }
    }

    public void addEntry(JournalEntry newJournal) {
        int idx = this.getSelectedRow();
        int u = this.getEntryTableModel().addEntry(newJournal);
        if (u != -1 && idx != -1 && idx < u) {
            this.addRowSelectionInterval(idx, idx);
        }
    }

    public void updateEntry(JournalEntry updatedJournal) {
        int idx = this.getSelectedRow();
        int u = this.getEntryTableModel().updateEntry(updatedJournal);
        if (u != -1 && idx != -1 && idx < this.getEntryTableModel().getEntries().size()) {
            this.addRowSelectionInterval(idx, idx);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            System.out.println("************* " + ++this.x + " : " + this.getSelectedRow());
        }
    }
}

