/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.util.calendar;

import java.util.Calendar;

public class CalendarTools {
    public static int getMonth(int i) {
        switch (i) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
        }
        throw new RuntimeException("Value \"" + i + "\" not understood as a month");
    }

    public static Calendar getNthDayOfWeekOfMonth(int nth, int dayOfWeek, int month, int year) {
        Calendar cal = CalendarTools.getDateOfMonth(1, month, year);
        while (cal.get(7) != dayOfWeek) {
            cal.add(5, 1);
        }
        cal.add(5, (nth - 1) * 7);
        return cal;
    }

    public static Calendar getDateOfMonth(int date, int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month);
        cal.set(5, date);
        cal.set(1, year);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getDateOfMonthEveryNYearsStartingInYear(int date, int month, int year, int n, int startingInYear) {
        Calendar cal = null;
        if ((year - startingInYear) % n == 0) {
            cal = CalendarTools.getDateOfMonth(date, month, year);
        }
        return cal;
    }

    public static Calendar getLastDayOfMonth(int day, int month, int year) {
        switch (month) {
            case 0: {
                month = 1;
                break;
            }
            case 1: {
                month = 2;
                break;
            }
            case 2: {
                month = 3;
                break;
            }
            case 3: {
                month = 4;
                break;
            }
            case 4: {
                month = 5;
                break;
            }
            case 5: {
                month = 6;
                break;
            }
            case 6: {
                month = 7;
                break;
            }
            case 7: {
                month = 8;
                break;
            }
            case 8: {
                month = 9;
                break;
            }
            case 9: {
                month = 10;
                break;
            }
            case 10: {
                month = 11;
                break;
            }
            case 11: {
                month = 0;
                ++year;
            }
        }
        Calendar cal = CalendarTools.getDateOfMonth(1, month, year);
        cal.add(5, -1);
        while (cal.get(7) != day) {
            cal.add(5, -1);
        }
        return cal;
    }
}

