/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.ferris.swing.event.AppendAllEvent;
import org.ferris.swing.event.AppendListener;
import org.ferris.swing.event.AppendResetEvent;
import org.ferris.swing.text.AppendDocument;
import org.ferris.swing.text.AppendDocumentBody;
import org.ferris.swing.text.AppendDocumentHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAppendTextArea
extends JTextArea {
    private static final long serialVersionUID = 5966926812696938841L;
    private Logger log = Logger.getLogger(this.getClass());
    protected Set<AppendListener> appendListeners;
    protected MyKeyAdapter myKeyAdapter;
    private boolean appendedAll = false;

    public JAppendTextArea(AppendDocument doc) {
        super(doc);
        this.addKeyListener(this.getMyKeyAdapter());
    }

    public int getHeaderLineCount() {
        return this.getAppendDocument().getHeader().getLineCount();
    }

    public int getBodyLineCount() {
        return this.getAppendDocument().getBody().getLineCount();
    }

    public void addAppendListener(AppendListener listener) {
        this.getAppendListeners().add(listener);
    }

    public boolean removeAppendListener(AppendListener listener) {
        return this.getAppendListeners().remove(listener);
    }

    public boolean append() {
        return this.getAppendDocument().append();
    }

    public void appendAll() {
        this.appendedAll = true;
        this.getAppendDocument().appendAll();
    }

    public boolean appendedAll() {
        if (this.getAppendDocument().hasNext()) {
            return this.appendedAll;
        }
        return true;
    }

    protected MyKeyAdapter getMyKeyAdapter() {
        if (this.myKeyAdapter == null) {
            this.myKeyAdapter = new MyKeyAdapter();
        }
        return this.myKeyAdapter;
    }

    protected Set<AppendListener> getAppendListeners() {
        if (this.appendListeners == null) {
            this.appendListeners = new HashSet<AppendListener>();
        }
        return this.appendListeners;
    }

    protected void fireAppendAllEvent() {
        this.log.info((Object)"ENTER fireAppendAllEvent()");
        for (AppendListener listener : this.getAppendListeners()) {
            listener.append(new AppendAllEvent());
        }
    }

    protected void fireAppendResetEvent() {
        this.log.info((Object)"ENTER fireAppendResetEvent()");
        for (AppendListener listener : this.getAppendListeners()) {
            listener.reset(new AppendResetEvent());
        }
    }

    protected AppendDocument getAppendDocument() {
        return (AppendDocument)this.getDocument();
    }

    public void reset(AppendDocumentHeader header, AppendDocumentBody body, int appendLineCount) {
        this.log.info((Object)"ENTER reset()");
        this.getAppendDocument().reset(header, body, appendLineCount);
        this.fireAppendResetEvent();
    }

    public void reset(AppendDocumentHeader header, AppendDocumentBody body) {
        this.log.info((Object)"ENTER reset()");
        this.getAppendDocument().reset(header, body, this.getAppendDocument().getAppendLineCount());
        this.fireAppendResetEvent();
    }

    protected class MyKeyAdapter
    extends KeyAdapter {
        protected MyKeyAdapter() {
        }

        public void keyPressed(KeyEvent evnt) {
            if (evnt.getKeyCode() == 35 && evnt.isControlDown()) {
                JAppendTextArea.this.log.info((Object)"Key combination [ctrl]-[end] pressed");
                evnt.consume();
                JAppendTextArea.this.fireAppendAllEvent();
            }
        }
    }
}

