package org.ferris.journal.gui.controller;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.util.Calendar;
import java.util.Date;

import org.ferris.journal.gui.data.JournalData;
import org.ferris.journal.gui.data.JournalEntryData;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.frame.KEntryFrame;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.awt.ContainerTools;
import org.ferris.swing.JComponentTools;

public class EntryController 
{
	private Model model;
	private EntryController setModel(Model model) {
		this.model = model; return this;
	}
	private Model getModel() {
		return this.model;
	}
	
	
	private KEntryFrame view;
	private EntryController setView() {
		this.view = new KEntryFrame(this, getModel());
		return this;
	}
	private KEntryFrame getView() {
		return this.view;
	}
	
	private EntryController setData()
	{
		getModel().setJournals(
			JournalData.getInstance().findAll(getModel().getAccount())
		);
		
		return this;
	}
	
	public EntryController(Model model) { 
		setModel(model)
			.setData()
			.setView()
			.getView().setVisible(true);
	}
	
	
	public void exit() {
		getModel().release();
	}
	
	
	public void addEditJournals() {
		new JournalsController(getModel());
	}
	
	
	public void searchJournalEntries() {
		new SearchController(getModel());
	}
	

	public void insertEntry(		
		  final Journal journal
		, final Date day
		, final String subject
		, final String entry
	) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.entry.newEntry"));		
				JournalEntry j = new JournalEntry();
				
				model.performingOperation(getString("op.entry.setAccount"));
				j.setAccount(model.getAccount());	
				
				model.performingOperation(getString("op.entry.setJournal"));
				j.setJournal(journal);
				
				model.performingOperation(getString("op.entry.setCreatedOn"));
				j.setCreatedOn(Calendar.getInstance());					
				
				model.performingOperation(getString("op.entry.setDay")); {
					Calendar cal = Calendar.getInstance();
					cal.setTime(day);
					j.setDay(cal);
				}
				
				model.performingOperation(getString("op.entry.setSubject"));
				j.setSubject(subject);
				
				model.performingOperation(getString("op.entry.setEntry"));
				j.setEntry(entry);
				
				model.performingOperation(getString("op.entry.insert"));
				j = JournalEntryData.getInstance().insert(j);
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.entry.inserted"));
				model.insertJournalEntry(j);
			}
		}.start();
	}
	
	
	public void updateEntry(
		  final Long journalEntryId
		, final Journal journal
		, final Date day
		, final String subject
		, final String entry
	) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.entry.newEntry"));		
				JournalEntry j = new JournalEntry();
				
				model.performingOperation(getString("op.entry.setAccount"));
				j.setAccount(model.getAccount());	
				
				model.performingOperation(getString("op.entry.setJournal"));
				j.setJournal(journal);
				
				model.performingOperation(getString("op.entry.setId"));
				j.setId(journalEntryId);
				
				model.performingOperation(getString("op.entry.setCreatedOn"));
				j.setCreatedOn(Calendar.getInstance());					
				
				model.performingOperation(getString("op.entry.setDay")); {
					Calendar cal = Calendar.getInstance();
					cal.setTime(day);
					j.setDay(cal);
				}
				
				model.performingOperation(getString("op.entry.setSubject"));
				j.setSubject(subject);
				
				model.performingOperation(getString("op.entry.setEntry"));
				j.setEntry(entry);
				
				model.performingOperation(getString("op.entry.update"));
				j = JournalEntryData.getInstance().update(j);
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.entry.updated"));
				model.updateJournalEntry(j);
			}
		}.start();
	}
	
	
	public void newEntry(
	) 
	{
		new Thread() {
			public void run() 
			{	
				model.performingOperation(getString("op.entry.new"));
				model.newJournalEntry();
			}
		}.start();
	}
	
	
	public void deleteEntry(final JournalEntry journalEntryBeingEdited) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);					
				
				model.performingOperation(getString("op.entry.delete"));
				JournalEntryData.getInstance().delete(
					  model.getAccount().getId()  		// id of account
					, journalEntryBeingEdited.getId()	// id of journal entry
				);
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.entry.deleted"));
				model.deleteJournalEntry(journalEntryBeingEdited);
			}
		}.start();
		
			
	}
	
}
