package org.ferris.journal.gui.controller;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.ferris.awt.ContainerTools;
import org.ferris.journal.gui.data.JournalData;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KJournalsFrame;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.swing.JComponentTools;
import org.ferris.swing.ui.ThrowableDialog;

public class JournalsController 
{
	private Model model;
	private JournalsController setModel(Model model) {
		this.model = model; return this;
	}
	private Model getModel() {
		return this.model;
	}
	
	
	private JournalsController setData()
	{
		if (getModel().getAllJournals() == null) {
			new ThrowableDialog(new Exception("Journal data not already set."), true);
		}
		return this;
	}
	
	private KJournalsFrame view;
	private JournalsController setView() 
	{
		this.view = new KJournalsFrame(this, getModel());
		
		return this;
	}
	private KJournalsFrame getView() {
		return this.view;
	}
	
	
	public JournalsController(Model model) { 
		setModel(model)
		    .setData()
			.setView()
			.getView().setVisible(true);
	}
	
	
	public void closeFrame() {
		getView().setVisible(false);
		getView().dispose();	
	}
	
	
	public void addEditJournals() {
		new JournalsController(getModel());
	}
	
	
	
	
	public void insertJournal(final String journalName,final boolean isActive) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.journal.newJournal"));		
				Journal j = new Journal();
				
				model.performingOperation(getString("op.journal.setAccount"));
				j.setAccount(model.getAccount());		
				
				model.performingOperation(getString("op.journal.setCreatedOn"));
				j.setCreatedOn(Calendar.getInstance());					
				
				model.performingOperation(getString("op.journal.setName"));
				j.setName(journalName);
				
				model.performingOperation(getString("op.journal.setIsActive"));
				j.setIsActive(isActive);
				
				model.performingOperation(getString("op.journal.insert"));
				j = JournalData.getInstance().insert(j);
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.journal.inserted"));
				model.insertJournal(j);
			}
		}.start();
	}
	
	
	public void updateJournal(final Long journalId, final String journalName,final boolean journalIsActive) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);					
				
				model.performingOperation(getString("op.journal.findingId"));	
				Journal existingData
					= JournalData.getInstance().find(model.getAccount(), journalId);
				
				
				if (existingData == null) 
				{
					model.performingOperation(getString("op.journal.id.missing"));
					List<String>
						errors = new ArrayList<String>();
					errors.add(getString("journal.id.missing"));
					new KErrorDialog(view, errors);
					return;
				}
				
				model.performingOperation(getString("op.journal.setName"));		
				existingData.setName(journalName);
				
				model.performingOperation(getString("op.journal.setIsActive"));
				existingData.setIsActive(journalIsActive);
				
				model.performingOperation(getString("op.journal.update"));
				existingData = JournalData.getInstance().update(existingData);
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.journal.updated"));
				model.updateJournal(existingData);
			}
		}.start();
	}	
	
	
	public void newJournal() 
	{
		new Thread() {
			public void run() 
			{	
				try {
					model.performingOperation(getString("op.journal.new"));
					model.newJournal();
				}
				finally {
				}					
			}
		}.start();
	}
	
	
	public void deleteJournal(final Journal j) 
	{
		new Thread() {
			public void run() 
			{	
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, false
				);
				JComponentTools.setWaitCursor(
					view.getJContentPane()
				);					
				
				model.performingOperation(getString("op.journal.delete"));
				JournalData.getInstance().delete(model.getAccount(), j.getId());
				
				ContainerTools.setEnabled(
					  view.getJContentPane()
					, true
				);
				JComponentTools.setDefaultCursor(
					view.getJContentPane()
				);
				
				model.performingOperation(getString("op.journal.deleted"));
				model.deleteJournal(j);
			}
		}.start();
	}
	
}
