package org.ferris.journal.gui.crypto;

import java.beans.XMLDecoder;
import java.io.InputStream;

import org.apache.log4j.Logger;
import org.ferris.crypto.KeyMaterialLocator;

public class KeyMaterialLocatorForBlowfish implements KeyMaterialLocator 
{
	private Logger log = Logger.getLogger(getClass());
	
	@Override
	public byte[] locate() 
	{
		log.info("Enter locate()");
		
		log.info("Find Blowfish secret byte[]");
		String secretKeyResource = "/FerrisBlowfish.xml";
		InputStream is
			= getClass().getResourceAsStream(secretKeyResource);
		if (is == null) {
			throw new RuntimeException(
				String.format(
					"Blowfish secret byte [] resource \"%s\" not found."
					, secretKeyResource
				)
			);
		}
		
		log.info("Create XMLDecoder");
		XMLDecoder decoder = new XMLDecoder(is);
		
		log.info("Call readObject to get secretKey");
		byte[] secretKey = (byte[])decoder.readObject();		
		if (secretKey == null) {
			throw new RuntimeException(
				String.format(
					"Blowfish secret byte [] resource \"%s\" decoded to null."
					, secretKeyResource
				)			
			);
		}
		//log.info("Byte array: " + Arrays.toString(secretKey));
		return secretKey;
	}

}
